/*
 * Copyright 2016 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.workbench.common.services.refactoring.model.index.terms;

import org.jboss.errai.common.client.api.annotations.Portable;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.services.refactoring.service.ResourceType;

/**
 * For fields that describe other resources referred to in the resource being indexed.
 */
@Portable
public class ReferenceIndexTerm implements CompositeIndexTerm {

    public static final String TERM = "ref";

    private ResourceType resourceType;

    public ReferenceIndexTerm() {
        // default constructor
    }

    public ReferenceIndexTerm(ResourceType type) {
        this.resourceType = PortablePreconditions.checkNotNull("resourceType",
                                                               type);
    }

    @Override
    public String getTerm() {
        return TERM + ":" + this.resourceType.toString();
    }

    @Override
    public String getTermBase() {
        return TERM;
    }
}
