package org.jboss.brmsbpmsuite.patching.client;

import com.google.common.collect.Lists;
import org.jboss.brmsbpmsuite.patching.phase.PatchingPhase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

import java.io.File;
import java.util.Collection;
import java.util.List;

@RunWith(Parameterized.class)
public class PatchingPhasesTest extends BaseClientPatcherTest {

    @Parameterized.Parameters(name = "{index}: {0}")
    public static Collection<Object[]> data() {
        return Lists.newArrayList(new Object[][]{
                {Lists.newArrayList(PatchingPhase.CHECK_DISTRO)},
                {Lists.newArrayList(PatchingPhase.CHECK_VERSION)},
                {Lists.newArrayList(PatchingPhase.BACKUP)},
                {Lists.newArrayList(PatchingPhase.APPLY)},

                {Lists.newArrayList(PatchingPhase.CHECK_DISTRO, PatchingPhase.CHECK_VERSION, PatchingPhase.APPLY)},
                {Lists.newArrayList(PatchingPhase.CHECK_DISTRO, PatchingPhase.CHECK_VERSION, PatchingPhase.BACKUP, PatchingPhase.APPLY)}
        });
    }

    @Parameterized.Parameter()
    public List<PatchingPhase> expectedPhases;

    @Test
    public void shouldExecuteOnlySpecifiedPhases() {
        ClientPatcherConfig config = new ClientPatcherConfig();
        config.setPhasesToExecute(expectedPhases);
        ClientPatcherRunner runner = new ClientPatcherRunner(config);
        TestingPatcher patcher = new TestingPatcher();
        runner.runDistributionPatcher(patcher, config.getBackupDir());
        List<PatchingPhase> actualPhases = patcher.getExecutedPhases();
        Assert.assertEquals("Expected phases are different from the actual ones!", expectedPhases, actualPhases);
    }

    private class TestingPatcher implements DistributionPatcher {
        private List<PatchingPhase> executedPhases = Lists.newArrayList();

        public List<PatchingPhase> getExecutedPhases() {
            return executedPhases;
        }

        @Override
        public void checkDistro() {
            executedPhases.add(PatchingPhase.CHECK_DISTRO);
        }

        @Override
        public void checkVersion() {
            executedPhases.add(PatchingPhase.CHECK_VERSION);
        }

        @Override
        public void backup(File backupDir) {
            executedPhases.add(PatchingPhase.BACKUP);
        }

        @Override
        public void apply() {
            executedPhases.add(PatchingPhase.APPLY);
        }

        @Override
        public void explodeWar() {
            executedPhases.add(PatchingPhase.EXPLODE_WAR);
        }

        @Override
        public void zipWar() {
            executedPhases.add(PatchingPhase.ZIP_WAR);
        }
    }

}
