package org.jboss.brmsbpmsuite.patching.client;

import org.jboss.brmsbpmsuite.patching.systemproperty.SystemPropertyDiffExtractor;
import org.jboss.brmsbpmsuite.patching.xml.XMLDocumentDao;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import java.io.*;

public class ConfigurationDiffsGenerator {

    private final File oldConfigDir;
    private final File newConfigDir;
    private final File outputDir;
    private final XMLDocumentDao documentDao;

    public ConfigurationDiffsGenerator(File oldConfigDir, File newConfigDir, File outputDir) throws ParserConfigurationException, TransformerConfigurationException {
        this.oldConfigDir = oldConfigDir;
        this.newConfigDir = newConfigDir;
        this.outputDir = outputDir;
        this.documentDao = new XMLDocumentDao();
    }

    public void generateDiffs() throws SAXException, TransformerException, ParserConfigurationException, IOException {
        outputDir.mkdirs();
        File[] newFiles = newConfigDir.listFiles((dir, name) -> name.matches("standalone.*\\.xml"));
        newFiles = newFiles == null ? new File[0] : newFiles;
        for (File newFile : newFiles) {
            File oldFile = new File(oldConfigDir, newFile.getName());
            if (oldFile.exists()) {
                generateDiff(newFile.getName());
            }
        }
    }

    private void generateDiff(String filename) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        File oldFile = new File(oldConfigDir, filename);
        File newFile = new File(newConfigDir, filename);

        InputStream oldInputStream = new FileInputStream(oldFile);
        InputStream newInputStream = new FileInputStream(newFile);

        Document baseDocument = documentDao.load(oldInputStream);
        Document updateDocument = documentDao.load(newInputStream);

        SystemPropertyDiffExtractor diffExtractor = new SystemPropertyDiffExtractor(baseDocument);
        Document diffDocument = diffExtractor.createDiff(updateDocument);

        // save only when there are differences
        if (diffDocument.getDocumentElement().getChildNodes().getLength() > 0) {
            File outputFile = new File(outputDir, filename);
            OutputStream diffOutputStream = new FileOutputStream(outputFile);
            documentDao.save(diffOutputStream, diffDocument);
        }
    }

    public static void main(String[] args) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        File oldConfigDir = new File(args[0] + "/standalone/configuration");
        File newConfigDir = new File(args[1] + "/standalone/configuration");
        File outputDir = new File(args[2]);

        ConfigurationDiffsGenerator diffsGenerator = new ConfigurationDiffsGenerator(oldConfigDir, newConfigDir, outputDir);
        diffsGenerator.generateDiffs();
    }

}
