/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.om.NamePool;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;

public class ContentTypeTest
extends NodeTest {
    private int kind;
    private int requiredType;
    private NamePool namePool;

    public ContentTypeTest(int n, SchemaType schemaType) {
        this.kind = n;
        this.requiredType = schemaType.getFingerprint();
        this.namePool = schemaType.getNamePool();
        this.originalText = schemaType.getDescription();
    }

    public ItemType getSuperType() {
        return NodeKindTest.makeNodeKindTest(this.kind);
    }

    public boolean matches(int n, int n2, int n3) {
        if (this.kind != n) {
            return false;
        }
        if (n3 == this.requiredType) {
            return true;
        }
        if (n3 == -1) {
            return false;
        }
        SchemaType schemaType = this.namePool.getSchemaType(n3).getBaseType();
        while (schemaType != null) {
            if (schemaType.getFingerprint() == this.requiredType) {
                return true;
            }
            schemaType = schemaType.getBaseType();
        }
        return false;
    }

    public final double getDefaultPriority() {
        return 0.0;
    }

    public int getNodeKind() {
        return this.kind;
    }

    public boolean allowsTextNodes() {
        return false;
    }

    public String toString() {
        return this.originalText;
    }
}

