/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.file;

import alt.jiapi.file.Attribute;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public class LineNumberTableAttribute
extends Attribute {
    private List lineNumbers = new LinkedList();
    public static final String ATTRIBUTE_NAME = "LineNumberTable";

    LineNumberTableAttribute(short nameIndex, DataInputStream dis) throws IOException {
        super(nameIndex);
        int length = dis.readShort();
        for (int i = 0; i < length; ++i) {
            short start_pc = dis.readShort();
            short line_number = dis.readShort();
            this.lineNumbers.add(new Entry(start_pc, line_number));
        }
    }

    public List getEntries() {
        return this.lineNumbers;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeShort(this.lineNumbers.size());
            for (Entry lnte : this.lineNumbers) {
                dos.writeShort(lnte.getStartPc());
                dos.writeShort(lnte.getLineNumber());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return baos.toByteArray();
    }

    public class Entry {
        private short start_pc;
        private short line_number;

        public Entry(short start_pc, short line_number) {
            this.start_pc = start_pc;
            this.line_number = line_number;
        }

        public short getStartPc() {
            return this.start_pc;
        }

        public void setStartPc(short start_pc) {
            this.start_pc = start_pc;
        }

        public short getLineNumber() {
            return this.line_number;
        }
    }
}

