/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AttributeReference;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.sort.DocumentSorter;
import net.sf.saxon.sort.Reverser;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public final class PathExpression
extends ComputedExpression
implements MappingFunction {
    private Expression start;
    private Expression step;

    public PathExpression(Expression expression, Expression expression2) {
        this.start = expression;
        this.step = expression2;
        if (expression2 instanceof PathExpression) {
            PathExpression pathExpression = (PathExpression)expression2;
            if (PathExpression.isFilteredAxisPath(pathExpression.start) && PathExpression.isFilteredAxisPath(pathExpression.step)) {
                this.start = new PathExpression(expression, pathExpression.start);
                ExpressionTool.copyLocationInfo(expression, this.start);
                this.step = pathExpression.step;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isFilteredAxisPath(Expression var0) {
        if (!(var0 instanceof AxisExpression)) ** GOTO lbl4
        return true;
lbl-1000:
        // 1 sources

        {
            var0 = ((FilterExpression)var0).getBaseExpression();
lbl4:
            // 2 sources

            ** while (var0 instanceof FilterExpression)
        }
lbl5:
        // 1 sources

        return var0 instanceof AxisExpression;
    }

    public final ItemType getItemType() {
        return this.step.getItemType();
    }

    public Expression simplify() throws XPathException {
        this.start = this.start.simplify();
        this.step = this.step.simplify();
        if (this.start instanceof EmptySequence) {
            return this.start;
        }
        if (this.step instanceof EmptySequence) {
            return this.step;
        }
        if (this.start instanceof ContextItemExpression && this.step instanceof PathExpression && (this.step.getSpecialProperties() & 0x20000) != 0) {
            return this.step;
        }
        if (this.step instanceof ContextItemExpression && this.start instanceof PathExpression && (this.start.getSpecialProperties() & 0x20000) != 0) {
            return this.start;
        }
        if (this.start instanceof RootExpression && this.step instanceof ParentNodeExpression) {
            return EmptySequence.getInstance();
        }
        return this;
    }

    private PathExpression simplifyDescendantPath() throws XPathException {
        ComputedExpression computedExpression;
        ComputedExpression computedExpression2;
        Expression expression = this.start;
        if (this.start instanceof AxisExpression) {
            computedExpression2 = (AxisExpression)this.start;
            if (computedExpression2.getAxis() != 5) {
                return null;
            }
            computedExpression = new ContextItemExpression();
            ExpressionTool.copyLocationInfo(this, computedExpression);
            expression = new PathExpression(computedExpression, computedExpression2);
            ExpressionTool.copyLocationInfo(this, expression);
        }
        if (!(expression instanceof PathExpression)) {
            return null;
        }
        computedExpression2 = (PathExpression)expression;
        if (!(((PathExpression)computedExpression2).step instanceof AxisExpression)) {
            return null;
        }
        computedExpression = (AxisExpression)((PathExpression)computedExpression2).step;
        if (((AxisExpression)computedExpression).getAxis() != 5) {
            return null;
        }
        NodeTest nodeTest = ((AxisExpression)computedExpression).getNodeTest();
        if (nodeTest != null && !(nodeTest instanceof AnyNodeTest)) {
            return null;
        }
        Expression expression2 = this.step;
        while (expression2 instanceof FilterExpression) {
            if (((FilterExpression)expression2).isPositional()) {
                return null;
            }
            expression2 = ((FilterExpression)expression2).getBaseExpression();
        }
        if (!(expression2 instanceof AxisExpression)) {
            return null;
        }
        AxisExpression axisExpression = (AxisExpression)expression2;
        if (axisExpression.getAxis() == 3) {
            ComputedExpression computedExpression3 = new AxisExpression(4, ((AxisExpression)expression2).getNodeTest());
            ExpressionTool.copyLocationInfo(this, computedExpression3);
            expression2 = this.step;
            while (expression2 instanceof FilterExpression) {
                computedExpression3 = new FilterExpression(computedExpression3, ((FilterExpression)expression2).getFilter());
                ExpressionTool.copyLocationInfo(expression2, computedExpression3);
                expression2 = ((FilterExpression)expression2).getBaseExpression();
            }
            PathExpression pathExpression = new PathExpression(((PathExpression)computedExpression2).start, computedExpression3);
            ExpressionTool.copyLocationInfo(this, pathExpression);
            return pathExpression;
        }
        if (axisExpression.getAxis() == 2) {
            AxisExpression axisExpression2 = new AxisExpression(5, NodeKindTest.ELEMENT);
            ExpressionTool.copyLocationInfo(this, axisExpression2);
            PathExpression pathExpression = new PathExpression(new PathExpression(((PathExpression)computedExpression2).start, axisExpression2), this.step);
            ExpressionTool.copyLocationInfo(this, pathExpression);
        }
        return null;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.start = this.start.analyze(staticContext);
        this.step = this.step.analyze(staticContext);
        this.start = ExpressionTool.unsorted(this.start, false);
        this.step = ExpressionTool.unsorted(this.step, false);
        RoleLocator roleLocator = new RoleLocator(1, "/", 0);
        this.start = TypeChecker.staticTypeCheck(this.start, SequenceType.NODE_SEQUENCE, false, roleLocator);
        RoleLocator roleLocator2 = new RoleLocator(1, "/", 1);
        this.step = TypeChecker.staticTypeCheck(this.step, SequenceType.NODE_SEQUENCE, false, roleLocator2);
        PathExpression pathExpression = this.simplifyDescendantPath();
        if (pathExpression != null) {
            return pathExpression.simplify().analyze(staticContext);
        }
        PromotionOffer promotionOffer = new PromotionOffer();
        promotionOffer.action = 10;
        promotionOffer.promoteDocumentDependent = (this.start.getSpecialProperties() & 0x10000) != 0;
        promotionOffer.containingExpression = this;
        this.step = this.step.promote(promotionOffer);
        if (promotionOffer.containingExpression instanceof LetExpression) {
            promotionOffer.containingExpression = promotionOffer.containingExpression.analyze(staticContext);
        }
        if (promotionOffer.containingExpression instanceof PathExpression) {
            PathExpression pathExpression2 = (PathExpression)promotionOffer.containingExpression;
            int n = pathExpression2.getSpecialProperties();
            if ((n & 0x20000) != 0) {
                return pathExpression2;
            }
            if ((n & 0x40000) != 0) {
                return new Reverser(pathExpression2);
            }
            return new DocumentSorter(pathExpression2);
        }
        return promotionOffer.containingExpression;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.start = this.start.promote(promotionOffer);
        if (promotionOffer.action == 12) {
            this.step = this.step.promote(promotionOffer);
        }
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.start, this.step};
        return expressionArray;
    }

    public int computeDependencies() {
        return this.start.getDependencies() | this.step.getDependencies() & 0x21;
    }

    public int computeSpecialProperties() {
        int n = this.start.getSpecialProperties();
        int n2 = this.step.getSpecialProperties();
        if (!Cardinality.allowsMany(this.start.getCardinality())) {
            n |= 0xA0000;
        }
        if (!Cardinality.allowsMany(this.step.getCardinality())) {
            n2 |= 0xA0000;
        }
        int n3 = 0;
        if ((n & n2 & 0x10000) != 0) {
            n3 |= 0x10000;
        }
        if ((n & n2 & 0x80000) != 0) {
            n3 |= 0x80000;
        }
        if ((n & n2 & 0x100000) != 0) {
            n3 |= 0x100000;
        }
        if (this.testNaturallySorted(n, n2)) {
            n3 |= 0x20000;
        }
        if (this.testNaturallyReverseSorted()) {
            n3 |= 0x40000;
        }
        return n3;
    }

    private boolean testNaturallySorted(int n, int n2) {
        if ((n2 & 0x20000) == 0) {
            return false;
        }
        if (!Cardinality.allowsMany(this.start.getCardinality())) {
            if ((n2 & 0x20000) != 0) {
                return true;
            }
        } else if ((n & 0x20000) == 0) {
            return false;
        }
        if ((n2 & 0x200000) != 0) {
            return true;
        }
        return (n & 0x80000) != 0 && (n2 & 0x100000) != 0;
    }

    private boolean testNaturallyReverseSorted() {
        if (!Cardinality.allowsMany(this.start.getCardinality()) && this.step instanceof AxisExpression) {
            return !Axis.isForwards[((AxisExpression)this.step).getAxis()];
        }
        if (!(this.start instanceof AxisExpression)) {
            return false;
        }
        if (Axis.isForwards[((AxisExpression)this.start).getAxis()]) {
            return false;
        }
        return this.step instanceof AttributeReference;
    }

    public int computeCardinality() {
        int n = this.start.getCardinality();
        int n2 = this.step.getCardinality();
        return Cardinality.multiply(n, n2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PathExpression)) {
            return false;
        }
        PathExpression pathExpression = (PathExpression)object;
        return this.start.equals(pathExpression.start) && this.step.equals(pathExpression.step);
    }

    public int hashCode() {
        return "PathExpression".hashCode() + this.start.hashCode() + this.step.hashCode();
    }

    public Expression getFirstStep() {
        if (this.start instanceof PathExpression) {
            return ((PathExpression)this.start).getFirstStep();
        }
        return this.start;
    }

    public Expression getRemainingSteps() {
        if (this.start instanceof PathExpression) {
            PathExpression pathExpression = new PathExpression(((PathExpression)this.start).getRemainingSteps(), this.step);
            ExpressionTool.copyLocationInfo(this.start, pathExpression);
            return pathExpression;
        }
        return this.step;
    }

    public Expression getLastStep() {
        if (this.step instanceof PathExpression) {
            return ((PathExpression)this.step).getLastStep();
        }
        return this.step;
    }

    public Expression getAllExceptLastStep() {
        if (this.step instanceof PathExpression) {
            PathExpression pathExpression = new PathExpression(this.start, ((PathExpression)this.step).getAllExceptLastStep());
            ExpressionTool.copyLocationInfo(this.start, pathExpression);
            return pathExpression;
        }
        return this.start;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.start.iterate(xPathContext);
        XPathContext xPathContext2 = xPathContext.newContext();
        xPathContext2.setCurrentIterator(sequenceIterator);
        sequenceIterator = new MappingIterator(sequenceIterator, this, xPathContext2, null);
        return sequenceIterator;
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        return this.step.iterate(xPathContext);
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "path /");
        this.start.display(n + 1, namePool);
        this.step.display(n + 1, namePool);
    }
}

