/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.kie.server.springboot.autoconfiguration;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "kieserver")
public class KieServerProperties implements InitializingBean {

    private String location = "";
    private String controllers = "";
    private String serverId = "SpringBoot";
    private String serverName = "KieServer-SpringBoot";
    
    private String restContextPath = "/rest";
    
    public String getServerId() {
        return serverId;
    }
    
    public void setServerId(String serverId) {
        this.serverId = serverId;
    }
    
    public String getServerName() {
        return serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }
    
    public String getRestContextPath() {
        return restContextPath;
    }
    
    public void setRestContextPath(String restContextPath) {
        this.restContextPath = restContextPath;
    }
    
    public String getLocation() {
        return location;
    }
    
    public void setLocation(String location) {
        this.location = location;
    }
    
    public String getControllers() {
        return controllers;
    }
    
    public void setControllers(String controllers) {
        this.controllers = controllers;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        
    }

}
