package com.redhat.installer.tests.installation.processpanel;

import com.redhat.installer.framework.mock.MockResourceBuilder;
import com.redhat.installer.framework.testers.ProcessPanelTester;
import com.redhat.installer.installation.processpanel.TomcatAddDataSource;
import com.redhat.installer.tests.TestUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Collectors;

import static junit.framework.TestCase.assertFalse;
import static junit.framework.TestCase.assertTrue;

public class TomcatAddDataSourceTest extends ProcessPanelTester {
    private final String contextXml = "/tomcat/context.xml";
    private final String copiedXml = "/conf/context.xml";

    @Before
    public void setUp() throws Exception {
        idata.langpack = TestUtils.createMockLangpack(tempFolder, "", "");
    }

    @After
    public void cleanup() {
        if (Files.exists(Paths.get(idata.getInstallPath() + copiedXml))) {
            MockResourceBuilder.deleteFile(idata.getInstallPath() + copiedXml);
        }
    }

    @Test
    public void testSuccess() throws Exception {
        MockResourceBuilder.copyResourceToInstall(contextXml, idata.getInstallPath() + copiedXml);
        boolean result = TomcatAddDataSource.run(handler, new String[]{"name=tom/test",
                "maxTotal=1000",
                "username=testerino",
                "password=hogwash"});
        assertCorrect(result);
    }

    // failure if context.xml doesn't exist
    @Test
    public void testFailure() {
        boolean result = TomcatAddDataSource.run(handler, new String[]{"name=tom/test",
                "maxTotal=1000",
                "username=testerino",
                "password=hogwash"});
        assertFalse(result);
    }

    private void assertCorrect(boolean result) throws Exception {
        assertTrue(result);
        String newFileString = Files.lines(Paths.get(tempFolder.getRoot().getPath() + copiedXml)).collect(Collectors.joining("\n"));
        Document modifiedXml = Jsoup.parse(newFileString, "", Parser.xmlParser());
        Elements contextElement = modifiedXml.getElementsByTag("Context");
        assertFalse(contextElement.isEmpty());
        Elements addedElement = modifiedXml.select("Resource[name=tom/test][maxTotal=1000][username=testerino][password=hogwash]");
        assertTrue(addedElement != null && addedElement.size() == 1);
    }
}
