package org.jboss.brmsbpmsuite.patching.client;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BPMSuiteClientPatcherApp extends ClientPatcherApp {
    private static final String DECISION_CENTRAL_WAR_FOLDER = "decision-central.war";
    private static final String BUSINESS_CENTRAL_WAR_FOLDER = "business-central.war";
    private static final String LAST_DM_MAJOR_MINOR = "7.59";
    private static Logger logger = LoggerFactory.getLogger(BPMSuiteClientPatcherApp.class);

    public static void main(String[] args) throws IOException {
        final CommonMainArgs commonMainArgs = new CommonMainArgsBuilder().parseArgs(args).build();
        ArgsValidator.getInstance().validateArgs(commonMainArgs, getSupportedDistributionTypes(commonMainArgs));

        ComparableVersion currentVersion = new ComparableVersion(getCurrentVersion(commonMainArgs.getDistributionRoot()));
        ComparableVersion latestDMMajorMinor = new ComparableVersion(LAST_DM_MAJOR_MINOR);
        if (commonMainArgs.getDistributionType().getTarget().equals(TargetProduct.RHDM)) {
            if (currentVersion.compareTo(latestDMMajorMinor) < 0) {
                logger.info("Update tool could not update current RHDM version into RHPAM. " +
                        "Please update RHDM to the latest available version and then run this command again.");
                System.exit(CommonMainArgs.SUCCESSFUL_EXIT);
            }
            final File distributionFolder = commonMainArgs.getDistributionRoot().getName().equals(DECISION_CENTRAL_WAR_FOLDER) ?
                    renameDMFolder(commonMainArgs.getDistributionRoot()) :
                    commonMainArgs.getDistributionRoot();
            mapRHDMArgsToRHPAM(commonMainArgs, distributionFolder);
        }
        commonMain(TargetProduct.RHPAM, DistributionType.getBPMSuiteDistributionTypes(), commonMainArgs);
    }

    private static File renameDMFolder(File distributionRoot) {
        File bcDistributionRoot = new File(distributionRoot.getParentFile(), BUSINESS_CENTRAL_WAR_FOLDER);
        distributionRoot.renameTo(bcDistributionRoot);
        logger.info("RHDM folder {} has been renamed to {}", distributionRoot.getName(), bcDistributionRoot.getName());
        return bcDistributionRoot;
    }

    private static void mapRHDMArgsToRHPAM(CommonMainArgs args, File distributionFolder) {
        args.setDistributionType(DistributionType.map(args.getDistributionType()));
        args.setDistributionRoot(distributionFolder);
    }

    private static List<DistributionType> getSupportedDistributionTypes(CommonMainArgs commonMainArgs) {
        return commonMainArgs.getDistributionType() == null ?
                Stream.concat(DistributionType.getBRMSDistributionTypes().stream(),
                        DistributionType.getBPMSuiteDistributionTypes().stream())
                        .collect(Collectors.toList()) :
                commonMainArgs.getDistributionType().getTarget().equals(TargetProduct.RHDM) ?
                        DistributionType.getBRMSDistributionTypes() :
                        DistributionType.getBPMSuiteDistributionTypes();
    }

    private static String getCurrentVersion(File rootDir) throws IOException {
        try {
            return PatchingUtils.implementationVersionFromBuildMetadata(rootDir);
        } catch (Exception e) {
            return PatchingUtils.implementationVersionFromManifest(rootDir);
        }
    }
}
