package org.jboss.brmsbpmsuite.patching.client;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.read.ListAppender;
import org.junit.Test;
import org.osgi.framework.Version;
import org.slf4j.LoggerFactory;

import java.util.Properties;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;

public class VersionCheckerProviderTest {

    @Test
    public void logErrorButCreateCheckerWhenVersionIsNotFinal() {
        ListAppender<ILoggingEvent> appender = new ListAppender<>();
        LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();
        appender.setContext(loggerContext);
        appender.start();

        Logger logger = (Logger) LoggerFactory.getLogger(VersionCheckerProvider.class);
        logger.addAppender(appender);

        Properties versionProperties = new Properties();
        versionProperties.put("version.community.min", "5.2.1.redhat-1");
        versionProperties.put("version.community.max", "6.2.1.Final-redhat-1");
        VersionCheckerProvider.createInstance(versionProperties);

        assertThat(appender.list.get(0).toString(), is("[ERROR] 5.2.1.redhat-1 (version.community.min) is not a final version"));
    }

    @Test
    public void loadVersionCheckerFromPropertiesFile() {
        Version patcheableVersion = Version.parseVersion("6.1.0.Final-redhat-2");
        VersionChecker versionChecker = VersionCheckerProvider.getInstance();

        assertThat(versionChecker.isValidForVersion(patcheableVersion), is(true));
    }

    @Test(expected = InvalidVersionException.class)
    public void throwExceptionWhenPropertiesAreNotFound() {
        Version patcheableVersion = Version.parseVersion("6.1.0.Final-redhat-2");
        VersionChecker versionChecker = VersionCheckerProvider.createInstance(new Properties());

        versionChecker.isValidForVersion(patcheableVersion);
    }

    @Test(expected = IllegalArgumentException.class)
    public void throwExceptionWhenVersionIsMalformed() {
        Version patcheableVersion = Version.parseVersion("6.1.0.Final-redhat-2");
        Properties versionProperties = new Properties();
        versionProperties.put("version.community.min", "a-bad-version");
        versionProperties.put("version.community.max", "6.2.1.Final-redhat-1");
        VersionChecker versionChecker = VersionCheckerProvider.createInstance(versionProperties);

        versionChecker.isValidForVersion(patcheableVersion);
    }

}