/*
 * Copyright 2017 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.guvnor.ala.ui.wildfly.client.handler;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

import org.guvnor.ala.ui.client.handler.BaseFormResolver;
import org.guvnor.ala.ui.client.handler.FormResolver;
import org.guvnor.ala.ui.wildfly.client.provider.WF10ProviderConfigPresenter;
import org.jboss.errai.ioc.client.api.ManagedInstance;

/**
 * Form resolver implementation for Wildlfy providers.
 * @see FormResolver
 */
@ApplicationScoped
public class WildflyFormResolver
        extends BaseFormResolver<WF10ProviderConfigPresenter> {

    @Inject
    public WildflyFormResolver(final ManagedInstance<WF10ProviderConfigPresenter> providerConfigPresenters) {
        super(providerConfigPresenters);
    }
}
