package org.jboss.brmsbpmsuite.patching.client;

import java.util.ArrayList;
import java.util.List;

public enum DistributionType {

    RHPAM_EAP7X_BC("rhpam-business-central-eap7-deployable", "business-central-eap7-deployable",
            "Updates Business Central (`business-central.war`)", TargetProduct.RHPAM),
    RHPAM_EE8_KIE("rhpam-kie-server-ee8", "kie-server-ee8", "Updates KIE Server (`kie-server.war`)", TargetProduct.RHPAM),
    RHPAM_EE7_CTRL("rhpam-controller-ee7", "controller-ee7",
            "Updates the headless Process Automation Manager controller (`controller.war`)", TargetProduct.RHPAM),
    RHPAM_JWS_KIE("rhpam-kie-server-jws", "kie-server-jws", "Updates KIE Server on Red Hat JBoss Web Server (`kie-server.war`)",
            TargetProduct.RHPAM),
    RHPAM_JWS_CTRL("rhpam-controller-jws", "controller-jws",
            "Updates the headless Process Automation Manager controller on Red Hat JBoss Web Server (`controller.war`)",
            TargetProduct.RHPAM);

    private final String name;
    private final String relativePath;
    private final String description;
    private final TargetProduct target;

    private DistributionType(String name, String relativePath, String description, TargetProduct target) {
        this.name = name;
        this.relativePath = relativePath;
        this.description = description;
        this.target = target;
    }

    public String getName() {
        return name;
    }

    public String getRelativePath() {
        return relativePath;
    }

    public String getDescription() {
        return description;
    }

    public TargetProduct getTarget() {
        return target;
    }

    public static final DistributionType fromString(String name) {
        for (DistributionType type : DistributionType.values()) {
            if (type.getName().equals(name)) {
                return type;
            }
        }
        throw new IllegalArgumentException("Unrecognized distribution type '" + name + "'! ");
    }

    public static List<DistributionType> getBPMSuiteDistributionTypes() {
        List<DistributionType> result = new ArrayList<DistributionType>();
        for (DistributionType type : DistributionType.values()) {
            if (TargetProduct.RHPAM.equals(type.getTarget())) {
                result.add(type);
            }
        }
        return result;
    }
}
