package org.jboss.brmsbpmsuite.patching.client;

import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

import static org.junit.Assert.assertTrue;

public class ClientPatcherAppTest extends BaseClientPatcherTest {
    private static final Logger logger = LoggerFactory.getLogger(ClientPatcherAppTest.class);

    @Test
    public void shouldPrintHelpCorrectly() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream tmpSysout = new PrintStream(baos);
        PrintStream origSysout = System.out;
        System.setOut(tmpSysout);
        try {
            ClientPatcherApp.printHelp(DistributionType.getBPMSuiteDistributionTypes());
        } finally {
            System.setOut(origSysout);
        }
        String helpString = baos.toString();
        logger.info("Help string (for BPM Suite supported distros): " + helpString);
        // do just basic sanity checks; comparing by String.equals() would be too error prone to even small changes
        assertTrue("Help string does not contain product name!", helpString.contains("The Red Hat Decision Manager and Red Hat Process Automation Manager client"));
        assertTrue("Help string does not contain usage info!", helpString.contains("Usage"));
        assertTrue("Help string does not contain list of supported types!",
                helpString.contains("Supported distribution types"));
    }

}
