package org.jboss.brmsbpmsuite.patching.client;

import com.google.common.collect.Lists;
import org.junit.Test;

import java.util.List;

public class DistributionTypeTest extends BaseClientPatcherTest {

    @Test
    public void shouldReturnCorrectListOfBPMSuiteDistributionTypes() {
        List<DistributionType> actualTypes = DistributionType.getBPMSuiteDistributionTypes();
        List<DistributionType> expectedTypes = Lists.newArrayList(
                DistributionType.RHPAM_EAP7X_BC,
                DistributionType.RHPAM_EE8_KIE,
                DistributionType.RHPAM_EE7_CTRL,
                DistributionType.RHPAM_JWS_KIE,
                DistributionType.RHPAM_JWS_CTRL
        );
        assertEqualsIgnoreOrder("List of BPM Suite distribution types differs from the expected!", expectedTypes, actualTypes);
    }
}
