/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer.lexicalpreservation;

import com.github.javaparser.GeneratedJavaParserConstants;
import com.github.javaparser.JavaToken;
import com.github.javaparser.TokenTypes;
import com.github.javaparser.ast.Node;
import com.github.javaparser.printer.lexicalpreservation.TextElement;
import com.github.javaparser.utils.Utils;

class TokenTextElement
extends TextElement {
    private final int tokenKind;
    private final String text;

    public static TokenTextElement newLine() {
        return new TokenTextElement(TokenTypes.eolTokenKind(), Utils.EOL);
    }

    TokenTextElement(JavaToken token) {
        this(token.getKind(), token.getText());
    }

    TokenTextElement(int tokenKind, String text) {
        this.tokenKind = tokenKind;
        this.text = text;
    }

    TokenTextElement(int tokenKind) {
        String content = GeneratedJavaParserConstants.tokenImage[tokenKind];
        if (content.startsWith("\"")) {
            content = content.substring(1, content.length() - 1);
        }
        if (TokenTypes.isEndOfLineToken(tokenKind)) {
            content = Utils.EOL;
        } else if (TokenTypes.isWhitespace(tokenKind)) {
            content = " ";
        }
        this.tokenKind = tokenKind;
        this.text = content;
    }

    @Override
    String expand() {
        return this.text;
    }

    String getText() {
        return this.text;
    }

    public int getTokenKind() {
        return this.tokenKind;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenTextElement that = (TokenTextElement)o;
        if (this.tokenKind != that.tokenKind) {
            return false;
        }
        return this.text.equals(that.text);
    }

    public int hashCode() {
        int result = this.tokenKind;
        result = 31 * result + this.text.hashCode();
        return result;
    }

    public String toString() {
        return "TokenTextElement(" + this.tokenKind + ") {" + this.text + '}';
    }

    @Override
    boolean isToken(int tokenKind) {
        return this.tokenKind == tokenKind;
    }

    @Override
    boolean isNode(Node node) {
        return false;
    }

    @Override
    public boolean isWhiteSpace() {
        return TokenTypes.isWhitespace(this.tokenKind);
    }

    @Override
    public boolean isSpaceOrTab() {
        return TokenTypes.isSpaceOrTab(this.tokenKind);
    }

    @Override
    public boolean isComment() {
        return TokenTypes.isComment(this.tokenKind);
    }

    @Override
    public boolean isNewline() {
        return TokenTypes.isEndOfLineToken(this.tokenKind);
    }

    @Override
    public boolean isChildOfClass(Class<? extends Node> nodeClass) {
        return false;
    }
}

