package org.jboss.brmsbpmsuite.patching.client;

import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;
import static org.hamcrest.core.IsNot.not;

public class ConfigurationDiffsGeneratorTest {

    private static final File TEMP_DIR = new File("./target/tmp-tests-dir");

    private static final File SERVER_1_CONFIG_DIR = createFileFromResource("/config-test/eap-servers/eap-version-1/standalone/configuration");
    private static final File SERVER_2_CONFIG_DIR = createFileFromResource("/config-test/eap-servers/eap-version-2/standalone/configuration");

    private ConfigurationDiffsGenerator testedConfigDiffsGenerator;

    @Before
    public void setUp() throws ParserConfigurationException, TransformerConfigurationException {
        TEMP_DIR.mkdirs();
        testedConfigDiffsGenerator = new ConfigurationDiffsGenerator(SERVER_1_CONFIG_DIR, SERVER_2_CONFIG_DIR, TEMP_DIR);
    }

    @After
    public void tearDown() throws IOException {
        FileUtils.deleteDirectory(TEMP_DIR);
    }

    @Test
    public void shouldIgnoreConfigFilesNotTargeted() throws SAXException, ParserConfigurationException, IOException, TransformerException {
        testedConfigDiffsGenerator.generateDiffs();

        File[] files = TEMP_DIR.listFiles(createFilenameFilter("ignored-config.xml"));
        assertThat(files.length, is(0));
    }

    @Test
    public void shouldNotIgnoreConfigFilesTargeted() throws SAXException, ParserConfigurationException, IOException, TransformerException {
        testedConfigDiffsGenerator.generateDiffs();

        File[] files = TEMP_DIR.listFiles(createFilenameFilter("standalone.*\\.xml"));
        assertThat(files.length, not(0));
    }

    @Test
    public void shouldNotProduceDiffForUnchangedFiles() throws SAXException, ParserConfigurationException, IOException, TransformerException {
        testedConfigDiffsGenerator.generateDiffs();

        File[] files = TEMP_DIR.listFiles(createFilenameFilter("standalone.xml"));
        assertThat(files.length, is(0));
    }

    private static File createFileFromResource(String filePath) {
        return new File(ConfigurationDiffsGeneratorTest.class.getResource(filePath).getPath());
    }

    private FilenameFilter createFilenameFilter(String regex) {
        return (dir, name) -> name.matches(regex);
    }

}