// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewImageCommitParams creates a new ImageCommitParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewImageCommitParams() *ImageCommitParams {
	return &ImageCommitParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewImageCommitParamsWithTimeout creates a new ImageCommitParams object
// with the ability to set a timeout on a request.
func NewImageCommitParamsWithTimeout(timeout time.Duration) *ImageCommitParams {
	return &ImageCommitParams{
		timeout: timeout,
	}
}

// NewImageCommitParamsWithContext creates a new ImageCommitParams object
// with the ability to set a context for a request.
func NewImageCommitParamsWithContext(ctx context.Context) *ImageCommitParams {
	return &ImageCommitParams{
		Context: ctx,
	}
}

// NewImageCommitParamsWithHTTPClient creates a new ImageCommitParams object
// with the ability to set a custom HTTPClient for a request.
func NewImageCommitParamsWithHTTPClient(client *http.Client) *ImageCommitParams {
	return &ImageCommitParams{
		HTTPClient: client,
	}
}

/*
ImageCommitParams contains all the parameters to send to the API endpoint

	for the image commit operation.

	Typically these are written to a http.Request.
*/
type ImageCommitParams struct {

	/* Author.

	   author of the image
	*/
	Author *string

	/* Changes.

	   instructions to apply while committing in Dockerfile format
	*/
	Changes *string

	/* Comment.

	   commit message
	*/
	Comment *string

	/* Container.

	   the name or ID of a container
	*/
	Container *string

	/* Pause.

	   pause the container before committing it
	*/
	Pause *bool

	/* Repo.

	   the repository name for the created image
	*/
	Repo *string

	/* Tag.

	   tag name for the created image
	*/
	Tag *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the image commit params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageCommitParams) WithDefaults() *ImageCommitParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the image commit params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageCommitParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the image commit params
func (o *ImageCommitParams) WithTimeout(timeout time.Duration) *ImageCommitParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the image commit params
func (o *ImageCommitParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the image commit params
func (o *ImageCommitParams) WithContext(ctx context.Context) *ImageCommitParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the image commit params
func (o *ImageCommitParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the image commit params
func (o *ImageCommitParams) WithHTTPClient(client *http.Client) *ImageCommitParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the image commit params
func (o *ImageCommitParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAuthor adds the author to the image commit params
func (o *ImageCommitParams) WithAuthor(author *string) *ImageCommitParams {
	o.SetAuthor(author)
	return o
}

// SetAuthor adds the author to the image commit params
func (o *ImageCommitParams) SetAuthor(author *string) {
	o.Author = author
}

// WithChanges adds the changes to the image commit params
func (o *ImageCommitParams) WithChanges(changes *string) *ImageCommitParams {
	o.SetChanges(changes)
	return o
}

// SetChanges adds the changes to the image commit params
func (o *ImageCommitParams) SetChanges(changes *string) {
	o.Changes = changes
}

// WithComment adds the comment to the image commit params
func (o *ImageCommitParams) WithComment(comment *string) *ImageCommitParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the image commit params
func (o *ImageCommitParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithContainer adds the container to the image commit params
func (o *ImageCommitParams) WithContainer(container *string) *ImageCommitParams {
	o.SetContainer(container)
	return o
}

// SetContainer adds the container to the image commit params
func (o *ImageCommitParams) SetContainer(container *string) {
	o.Container = container
}

// WithPause adds the pause to the image commit params
func (o *ImageCommitParams) WithPause(pause *bool) *ImageCommitParams {
	o.SetPause(pause)
	return o
}

// SetPause adds the pause to the image commit params
func (o *ImageCommitParams) SetPause(pause *bool) {
	o.Pause = pause
}

// WithRepo adds the repo to the image commit params
func (o *ImageCommitParams) WithRepo(repo *string) *ImageCommitParams {
	o.SetRepo(repo)
	return o
}

// SetRepo adds the repo to the image commit params
func (o *ImageCommitParams) SetRepo(repo *string) {
	o.Repo = repo
}

// WithTag adds the tag to the image commit params
func (o *ImageCommitParams) WithTag(tag *string) *ImageCommitParams {
	o.SetTag(tag)
	return o
}

// SetTag adds the tag to the image commit params
func (o *ImageCommitParams) SetTag(tag *string) {
	o.Tag = tag
}

// WriteToRequest writes these params to a swagger request
func (o *ImageCommitParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Author != nil {

		// query param author
		var qrAuthor string

		if o.Author != nil {
			qrAuthor = *o.Author
		}
		qAuthor := qrAuthor
		if qAuthor != "" {

			if err := r.SetQueryParam("author", qAuthor); err != nil {
				return err
			}
		}
	}

	if o.Changes != nil {

		// query param changes
		var qrChanges string

		if o.Changes != nil {
			qrChanges = *o.Changes
		}
		qChanges := qrChanges
		if qChanges != "" {

			if err := r.SetQueryParam("changes", qChanges); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.Container != nil {

		// query param container
		var qrContainer string

		if o.Container != nil {
			qrContainer = *o.Container
		}
		qContainer := qrContainer
		if qContainer != "" {

			if err := r.SetQueryParam("container", qContainer); err != nil {
				return err
			}
		}
	}

	if o.Pause != nil {

		// query param pause
		var qrPause bool

		if o.Pause != nil {
			qrPause = *o.Pause
		}
		qPause := swag.FormatBool(qrPause)
		if qPause != "" {

			if err := r.SetQueryParam("pause", qPause); err != nil {
				return err
			}
		}
	}

	if o.Repo != nil {

		// query param repo
		var qrRepo string

		if o.Repo != nil {
			qrRepo = *o.Repo
		}
		qRepo := qrRepo
		if qRepo != "" {

			if err := r.SetQueryParam("repo", qRepo); err != nil {
				return err
			}
		}
	}

	if o.Tag != nil {

		// query param tag
		var qrTag string

		if o.Tag != nil {
			qrTag = *o.Tag
		}
		qTag := qrTag
		if qTag != "" {

			if err := r.SetQueryParam("tag", qTag); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
