// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewImageListLibpodParams creates a new ImageListLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewImageListLibpodParams() *ImageListLibpodParams {
	return &ImageListLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewImageListLibpodParamsWithTimeout creates a new ImageListLibpodParams object
// with the ability to set a timeout on a request.
func NewImageListLibpodParamsWithTimeout(timeout time.Duration) *ImageListLibpodParams {
	return &ImageListLibpodParams{
		timeout: timeout,
	}
}

// NewImageListLibpodParamsWithContext creates a new ImageListLibpodParams object
// with the ability to set a context for a request.
func NewImageListLibpodParamsWithContext(ctx context.Context) *ImageListLibpodParams {
	return &ImageListLibpodParams{
		Context: ctx,
	}
}

// NewImageListLibpodParamsWithHTTPClient creates a new ImageListLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewImageListLibpodParamsWithHTTPClient(client *http.Client) *ImageListLibpodParams {
	return &ImageListLibpodParams{
		HTTPClient: client,
	}
}

/*
ImageListLibpodParams contains all the parameters to send to the API endpoint

	for the image list libpod operation.

	Typically these are written to a http.Request.
*/
type ImageListLibpodParams struct {

	/* All.

	   Show all images. Only images from a final layer (no children) are shown by default.
	*/
	All *bool

	/* Filters.

	     A JSON encoded value of the filters (a `map[string][]string`) to process on the images list. Available filters:
	- `before`=(`<image-name>[:<tag>]`,  `<image id>` or `<image@digest>`)
	- `dangling=true`
	- `label=key` or `label="key=value"` of an image label
	- `reference`=(`<image-name>[:<tag>]`)
	- `id`=(`<image-id>`)
	- `since`=(`<image-name>[:<tag>]`,  `<image id>` or `<image@digest>`)

	*/
	Filters *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the image list libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageListLibpodParams) WithDefaults() *ImageListLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the image list libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageListLibpodParams) SetDefaults() {
	var (
		allDefault = bool(false)
	)

	val := ImageListLibpodParams{
		All: &allDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the image list libpod params
func (o *ImageListLibpodParams) WithTimeout(timeout time.Duration) *ImageListLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the image list libpod params
func (o *ImageListLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the image list libpod params
func (o *ImageListLibpodParams) WithContext(ctx context.Context) *ImageListLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the image list libpod params
func (o *ImageListLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the image list libpod params
func (o *ImageListLibpodParams) WithHTTPClient(client *http.Client) *ImageListLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the image list libpod params
func (o *ImageListLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAll adds the all to the image list libpod params
func (o *ImageListLibpodParams) WithAll(all *bool) *ImageListLibpodParams {
	o.SetAll(all)
	return o
}

// SetAll adds the all to the image list libpod params
func (o *ImageListLibpodParams) SetAll(all *bool) {
	o.All = all
}

// WithFilters adds the filters to the image list libpod params
func (o *ImageListLibpodParams) WithFilters(filters *string) *ImageListLibpodParams {
	o.SetFilters(filters)
	return o
}

// SetFilters adds the filters to the image list libpod params
func (o *ImageListLibpodParams) SetFilters(filters *string) {
	o.Filters = filters
}

// WriteToRequest writes these params to a swagger request
func (o *ImageListLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.All != nil {

		// query param all
		var qrAll bool

		if o.All != nil {
			qrAll = *o.All
		}
		qAll := swag.FormatBool(qrAll)
		if qAll != "" {

			if err := r.SetQueryParam("all", qAll); err != nil {
				return err
			}
		}
	}

	if o.Filters != nil {

		// query param filters
		var qrFilters string

		if o.Filters != nil {
			qrFilters = *o.Filters
		}
		qFilters := qrFilters
		if qFilters != "" {

			if err := r.SetQueryParam("filters", qFilters); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
