// Code generated by go-swagger; DO NOT EDIT.

package pods

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// PodUnpauseLibpodReader is a Reader for the PodUnpauseLibpod structure.
type PodUnpauseLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PodUnpauseLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPodUnpauseLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewPodUnpauseLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewPodUnpauseLibpodConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPodUnpauseLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewPodUnpauseLibpodOK creates a PodUnpauseLibpodOK with default headers values
func NewPodUnpauseLibpodOK() *PodUnpauseLibpodOK {
	return &PodUnpauseLibpodOK{}
}

/*
PodUnpauseLibpodOK describes a response with status code 200, with default header values.

Unpause pod
*/
type PodUnpauseLibpodOK struct {
	Payload *models.PodUnpauseReport
}

// IsSuccess returns true when this pod unpause libpod o k response has a 2xx status code
func (o *PodUnpauseLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this pod unpause libpod o k response has a 3xx status code
func (o *PodUnpauseLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod unpause libpod o k response has a 4xx status code
func (o *PodUnpauseLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod unpause libpod o k response has a 5xx status code
func (o *PodUnpauseLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this pod unpause libpod o k response a status code equal to that given
func (o *PodUnpauseLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *PodUnpauseLibpodOK) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/unpause][%d] podUnpauseLibpodOK  %+v", 200, o.Payload)
}

func (o *PodUnpauseLibpodOK) String() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/unpause][%d] podUnpauseLibpodOK  %+v", 200, o.Payload)
}

func (o *PodUnpauseLibpodOK) GetPayload() *models.PodUnpauseReport {
	return o.Payload
}

func (o *PodUnpauseLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PodUnpauseReport)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodUnpauseLibpodNotFound creates a PodUnpauseLibpodNotFound with default headers values
func NewPodUnpauseLibpodNotFound() *PodUnpauseLibpodNotFound {
	return &PodUnpauseLibpodNotFound{}
}

/*
PodUnpauseLibpodNotFound describes a response with status code 404, with default header values.

No such pod
*/
type PodUnpauseLibpodNotFound struct {
	Payload *PodUnpauseLibpodNotFoundBody
}

// IsSuccess returns true when this pod unpause libpod not found response has a 2xx status code
func (o *PodUnpauseLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod unpause libpod not found response has a 3xx status code
func (o *PodUnpauseLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod unpause libpod not found response has a 4xx status code
func (o *PodUnpauseLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this pod unpause libpod not found response has a 5xx status code
func (o *PodUnpauseLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this pod unpause libpod not found response a status code equal to that given
func (o *PodUnpauseLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *PodUnpauseLibpodNotFound) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/unpause][%d] podUnpauseLibpodNotFound  %+v", 404, o.Payload)
}

func (o *PodUnpauseLibpodNotFound) String() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/unpause][%d] podUnpauseLibpodNotFound  %+v", 404, o.Payload)
}

func (o *PodUnpauseLibpodNotFound) GetPayload() *PodUnpauseLibpodNotFoundBody {
	return o.Payload
}

func (o *PodUnpauseLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodUnpauseLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodUnpauseLibpodConflict creates a PodUnpauseLibpodConflict with default headers values
func NewPodUnpauseLibpodConflict() *PodUnpauseLibpodConflict {
	return &PodUnpauseLibpodConflict{}
}

/*
PodUnpauseLibpodConflict describes a response with status code 409, with default header values.

Unpause pod
*/
type PodUnpauseLibpodConflict struct {
	Payload *models.PodUnpauseReport
}

// IsSuccess returns true when this pod unpause libpod conflict response has a 2xx status code
func (o *PodUnpauseLibpodConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod unpause libpod conflict response has a 3xx status code
func (o *PodUnpauseLibpodConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod unpause libpod conflict response has a 4xx status code
func (o *PodUnpauseLibpodConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this pod unpause libpod conflict response has a 5xx status code
func (o *PodUnpauseLibpodConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this pod unpause libpod conflict response a status code equal to that given
func (o *PodUnpauseLibpodConflict) IsCode(code int) bool {
	return code == 409
}

func (o *PodUnpauseLibpodConflict) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/unpause][%d] podUnpauseLibpodConflict  %+v", 409, o.Payload)
}

func (o *PodUnpauseLibpodConflict) String() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/unpause][%d] podUnpauseLibpodConflict  %+v", 409, o.Payload)
}

func (o *PodUnpauseLibpodConflict) GetPayload() *models.PodUnpauseReport {
	return o.Payload
}

func (o *PodUnpauseLibpodConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PodUnpauseReport)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodUnpauseLibpodInternalServerError creates a PodUnpauseLibpodInternalServerError with default headers values
func NewPodUnpauseLibpodInternalServerError() *PodUnpauseLibpodInternalServerError {
	return &PodUnpauseLibpodInternalServerError{}
}

/*
PodUnpauseLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type PodUnpauseLibpodInternalServerError struct {
	Payload *PodUnpauseLibpodInternalServerErrorBody
}

// IsSuccess returns true when this pod unpause libpod internal server error response has a 2xx status code
func (o *PodUnpauseLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod unpause libpod internal server error response has a 3xx status code
func (o *PodUnpauseLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod unpause libpod internal server error response has a 4xx status code
func (o *PodUnpauseLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod unpause libpod internal server error response has a 5xx status code
func (o *PodUnpauseLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this pod unpause libpod internal server error response a status code equal to that given
func (o *PodUnpauseLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *PodUnpauseLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/unpause][%d] podUnpauseLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PodUnpauseLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/pods/{name}/unpause][%d] podUnpauseLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PodUnpauseLibpodInternalServerError) GetPayload() *PodUnpauseLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *PodUnpauseLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodUnpauseLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
PodUnpauseLibpodInternalServerErrorBody pod unpause libpod internal server error body
swagger:model PodUnpauseLibpodInternalServerErrorBody
*/
type PodUnpauseLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod unpause libpod internal server error body
func (o *PodUnpauseLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod unpause libpod internal server error body based on context it is used
func (o *PodUnpauseLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodUnpauseLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodUnpauseLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res PodUnpauseLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PodUnpauseLibpodNotFoundBody pod unpause libpod not found body
swagger:model PodUnpauseLibpodNotFoundBody
*/
type PodUnpauseLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod unpause libpod not found body
func (o *PodUnpauseLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod unpause libpod not found body based on context it is used
func (o *PodUnpauseLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodUnpauseLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodUnpauseLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res PodUnpauseLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
