// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// LinuxNetwork LinuxNetwork identification and priority configuration
//
// swagger:model LinuxNetwork
type LinuxNetwork struct {

	// Set class identifier for container's network packets
	ClassID uint32 `json:"classID,omitempty"`

	// Set priority of network traffic for container
	Priorities []*LinuxInterfacePriority `json:"priorities"`
}

// Validate validates this linux network
func (m *LinuxNetwork) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePriorities(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LinuxNetwork) validatePriorities(formats strfmt.Registry) error {
	if swag.IsZero(m.Priorities) { // not required
		return nil
	}

	for i := 0; i < len(m.Priorities); i++ {
		if swag.IsZero(m.Priorities[i]) { // not required
			continue
		}

		if m.Priorities[i] != nil {
			if err := m.Priorities[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("priorities" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("priorities" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this linux network based on the context it is used
func (m *LinuxNetwork) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePriorities(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LinuxNetwork) contextValidatePriorities(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Priorities); i++ {

		if m.Priorities[i] != nil {
			if err := m.Priorities[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("priorities" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("priorities" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *LinuxNetwork) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LinuxNetwork) UnmarshalBinary(b []byte) error {
	var res LinuxNetwork
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
