// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewImageExportLibpodParams creates a new ImageExportLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewImageExportLibpodParams() *ImageExportLibpodParams {
	return &ImageExportLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewImageExportLibpodParamsWithTimeout creates a new ImageExportLibpodParams object
// with the ability to set a timeout on a request.
func NewImageExportLibpodParamsWithTimeout(timeout time.Duration) *ImageExportLibpodParams {
	return &ImageExportLibpodParams{
		timeout: timeout,
	}
}

// NewImageExportLibpodParamsWithContext creates a new ImageExportLibpodParams object
// with the ability to set a context for a request.
func NewImageExportLibpodParamsWithContext(ctx context.Context) *ImageExportLibpodParams {
	return &ImageExportLibpodParams{
		Context: ctx,
	}
}

// NewImageExportLibpodParamsWithHTTPClient creates a new ImageExportLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewImageExportLibpodParamsWithHTTPClient(client *http.Client) *ImageExportLibpodParams {
	return &ImageExportLibpodParams{
		HTTPClient: client,
	}
}

/*
ImageExportLibpodParams contains all the parameters to send to the API endpoint

	for the image export libpod operation.

	Typically these are written to a http.Request.
*/
type ImageExportLibpodParams struct {

	/* Compress.

	   use compression on image
	*/
	Compress *bool

	/* Format.

	   format for exported image (only docker-archive is supported)
	*/
	Format *string

	/* OciAcceptUncompressedLayers.

	   accept uncompressed layers when copying OCI images
	*/
	OciAcceptUncompressedLayers *bool

	/* References.

	   references to images to export
	*/
	References []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the image export libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageExportLibpodParams) WithDefaults() *ImageExportLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the image export libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageExportLibpodParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the image export libpod params
func (o *ImageExportLibpodParams) WithTimeout(timeout time.Duration) *ImageExportLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the image export libpod params
func (o *ImageExportLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the image export libpod params
func (o *ImageExportLibpodParams) WithContext(ctx context.Context) *ImageExportLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the image export libpod params
func (o *ImageExportLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the image export libpod params
func (o *ImageExportLibpodParams) WithHTTPClient(client *http.Client) *ImageExportLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the image export libpod params
func (o *ImageExportLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCompress adds the compress to the image export libpod params
func (o *ImageExportLibpodParams) WithCompress(compress *bool) *ImageExportLibpodParams {
	o.SetCompress(compress)
	return o
}

// SetCompress adds the compress to the image export libpod params
func (o *ImageExportLibpodParams) SetCompress(compress *bool) {
	o.Compress = compress
}

// WithFormat adds the format to the image export libpod params
func (o *ImageExportLibpodParams) WithFormat(format *string) *ImageExportLibpodParams {
	o.SetFormat(format)
	return o
}

// SetFormat adds the format to the image export libpod params
func (o *ImageExportLibpodParams) SetFormat(format *string) {
	o.Format = format
}

// WithOciAcceptUncompressedLayers adds the ociAcceptUncompressedLayers to the image export libpod params
func (o *ImageExportLibpodParams) WithOciAcceptUncompressedLayers(ociAcceptUncompressedLayers *bool) *ImageExportLibpodParams {
	o.SetOciAcceptUncompressedLayers(ociAcceptUncompressedLayers)
	return o
}

// SetOciAcceptUncompressedLayers adds the ociAcceptUncompressedLayers to the image export libpod params
func (o *ImageExportLibpodParams) SetOciAcceptUncompressedLayers(ociAcceptUncompressedLayers *bool) {
	o.OciAcceptUncompressedLayers = ociAcceptUncompressedLayers
}

// WithReferences adds the references to the image export libpod params
func (o *ImageExportLibpodParams) WithReferences(references []string) *ImageExportLibpodParams {
	o.SetReferences(references)
	return o
}

// SetReferences adds the references to the image export libpod params
func (o *ImageExportLibpodParams) SetReferences(references []string) {
	o.References = references
}

// WriteToRequest writes these params to a swagger request
func (o *ImageExportLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Compress != nil {

		// query param compress
		var qrCompress bool

		if o.Compress != nil {
			qrCompress = *o.Compress
		}
		qCompress := swag.FormatBool(qrCompress)
		if qCompress != "" {

			if err := r.SetQueryParam("compress", qCompress); err != nil {
				return err
			}
		}
	}

	if o.Format != nil {

		// query param format
		var qrFormat string

		if o.Format != nil {
			qrFormat = *o.Format
		}
		qFormat := qrFormat
		if qFormat != "" {

			if err := r.SetQueryParam("format", qFormat); err != nil {
				return err
			}
		}
	}

	if o.OciAcceptUncompressedLayers != nil {

		// query param ociAcceptUncompressedLayers
		var qrOciAcceptUncompressedLayers bool

		if o.OciAcceptUncompressedLayers != nil {
			qrOciAcceptUncompressedLayers = *o.OciAcceptUncompressedLayers
		}
		qOciAcceptUncompressedLayers := swag.FormatBool(qrOciAcceptUncompressedLayers)
		if qOciAcceptUncompressedLayers != "" {

			if err := r.SetQueryParam("ociAcceptUncompressedLayers", qOciAcceptUncompressedLayers); err != nil {
				return err
			}
		}
	}

	if o.References != nil {

		// binding items for references
		joinedReferences := o.bindParamReferences(reg)

		// query array param references
		if err := r.SetQueryParam("references", joinedReferences...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamImageExportLibpod binds the parameter references
func (o *ImageExportLibpodParams) bindParamReferences(formats strfmt.Registry) []string {
	referencesIR := o.References

	var referencesIC []string
	for _, referencesIIR := range referencesIR { // explode []string

		referencesIIV := referencesIIR // string as string
		referencesIC = append(referencesIC, referencesIIV)
	}

	// items.CollectionFormat: ""
	referencesIS := swag.JoinByFormat(referencesIC, "")

	return referencesIS
}
