// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewImagePruneLibpodParams creates a new ImagePruneLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewImagePruneLibpodParams() *ImagePruneLibpodParams {
	return &ImagePruneLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewImagePruneLibpodParamsWithTimeout creates a new ImagePruneLibpodParams object
// with the ability to set a timeout on a request.
func NewImagePruneLibpodParamsWithTimeout(timeout time.Duration) *ImagePruneLibpodParams {
	return &ImagePruneLibpodParams{
		timeout: timeout,
	}
}

// NewImagePruneLibpodParamsWithContext creates a new ImagePruneLibpodParams object
// with the ability to set a context for a request.
func NewImagePruneLibpodParamsWithContext(ctx context.Context) *ImagePruneLibpodParams {
	return &ImagePruneLibpodParams{
		Context: ctx,
	}
}

// NewImagePruneLibpodParamsWithHTTPClient creates a new ImagePruneLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewImagePruneLibpodParamsWithHTTPClient(client *http.Client) *ImagePruneLibpodParams {
	return &ImagePruneLibpodParams{
		HTTPClient: client,
	}
}

/*
ImagePruneLibpodParams contains all the parameters to send to the API endpoint

	for the image prune libpod operation.

	Typically these are written to a http.Request.
*/
type ImagePruneLibpodParams struct {

	/* All.

	   Remove all images not in use by containers, not just dangling ones

	*/
	All *bool

	/* External.

	   Remove images even when they are used by external containers (e.g, by build containers)

	*/
	External *bool

	/* Filters.

	   filters to apply to image pruning, encoded as JSON (map[string][]string). Available filters:
	- `dangling=<boolean>` When set to `true` (or `1`), prune only
	   unused *and* untagged images. When set to `false`
	   (or `0`), all unused images are pruned.
	- `until=<string>` Prune images created before this timestamp. The `<timestamp>` can be Unix timestamps, date formatted timestamps, or Go duration strings (e.g. `10m`, `1h30m`) computed relative to the daemon machine’s time.
	- `label` (`label=<key>`, `label=<key>=<value>`, `label!=<key>`, or `label!=<key>=<value>`) Prune images with (or without, in case `label!=...` is used) the specified labels.

	*/
	Filters *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the image prune libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImagePruneLibpodParams) WithDefaults() *ImagePruneLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the image prune libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImagePruneLibpodParams) SetDefaults() {
	var (
		allDefault = bool(false)

		externalDefault = bool(false)
	)

	val := ImagePruneLibpodParams{
		All:      &allDefault,
		External: &externalDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the image prune libpod params
func (o *ImagePruneLibpodParams) WithTimeout(timeout time.Duration) *ImagePruneLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the image prune libpod params
func (o *ImagePruneLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the image prune libpod params
func (o *ImagePruneLibpodParams) WithContext(ctx context.Context) *ImagePruneLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the image prune libpod params
func (o *ImagePruneLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the image prune libpod params
func (o *ImagePruneLibpodParams) WithHTTPClient(client *http.Client) *ImagePruneLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the image prune libpod params
func (o *ImagePruneLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAll adds the all to the image prune libpod params
func (o *ImagePruneLibpodParams) WithAll(all *bool) *ImagePruneLibpodParams {
	o.SetAll(all)
	return o
}

// SetAll adds the all to the image prune libpod params
func (o *ImagePruneLibpodParams) SetAll(all *bool) {
	o.All = all
}

// WithExternal adds the external to the image prune libpod params
func (o *ImagePruneLibpodParams) WithExternal(external *bool) *ImagePruneLibpodParams {
	o.SetExternal(external)
	return o
}

// SetExternal adds the external to the image prune libpod params
func (o *ImagePruneLibpodParams) SetExternal(external *bool) {
	o.External = external
}

// WithFilters adds the filters to the image prune libpod params
func (o *ImagePruneLibpodParams) WithFilters(filters *string) *ImagePruneLibpodParams {
	o.SetFilters(filters)
	return o
}

// SetFilters adds the filters to the image prune libpod params
func (o *ImagePruneLibpodParams) SetFilters(filters *string) {
	o.Filters = filters
}

// WriteToRequest writes these params to a swagger request
func (o *ImagePruneLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.All != nil {

		// query param all
		var qrAll bool

		if o.All != nil {
			qrAll = *o.All
		}
		qAll := swag.FormatBool(qrAll)
		if qAll != "" {

			if err := r.SetQueryParam("all", qAll); err != nil {
				return err
			}
		}
	}

	if o.External != nil {

		// query param external
		var qrExternal bool

		if o.External != nil {
			qrExternal = *o.External
		}
		qExternal := swag.FormatBool(qrExternal)
		if qExternal != "" {

			if err := r.SetQueryParam("external", qExternal); err != nil {
				return err
			}
		}
	}

	if o.Filters != nil {

		// query param filters
		var qrFilters string

		if o.Filters != nil {
			qrFilters = *o.Filters
		}
		qFilters := qrFilters
		if qFilters != "" {

			if err := r.SetQueryParam("filters", qFilters); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
