// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewImageUntagLibpodParams creates a new ImageUntagLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewImageUntagLibpodParams() *ImageUntagLibpodParams {
	return &ImageUntagLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewImageUntagLibpodParamsWithTimeout creates a new ImageUntagLibpodParams object
// with the ability to set a timeout on a request.
func NewImageUntagLibpodParamsWithTimeout(timeout time.Duration) *ImageUntagLibpodParams {
	return &ImageUntagLibpodParams{
		timeout: timeout,
	}
}

// NewImageUntagLibpodParamsWithContext creates a new ImageUntagLibpodParams object
// with the ability to set a context for a request.
func NewImageUntagLibpodParamsWithContext(ctx context.Context) *ImageUntagLibpodParams {
	return &ImageUntagLibpodParams{
		Context: ctx,
	}
}

// NewImageUntagLibpodParamsWithHTTPClient creates a new ImageUntagLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewImageUntagLibpodParamsWithHTTPClient(client *http.Client) *ImageUntagLibpodParams {
	return &ImageUntagLibpodParams{
		HTTPClient: client,
	}
}

/*
ImageUntagLibpodParams contains all the parameters to send to the API endpoint

	for the image untag libpod operation.

	Typically these are written to a http.Request.
*/
type ImageUntagLibpodParams struct {

	/* Name.

	   the name or ID of the container
	*/
	Name string

	/* Repo.

	   the repository to untag
	*/
	Repo *string

	/* Tag.

	   the name of the tag to untag
	*/
	Tag *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the image untag libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageUntagLibpodParams) WithDefaults() *ImageUntagLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the image untag libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageUntagLibpodParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the image untag libpod params
func (o *ImageUntagLibpodParams) WithTimeout(timeout time.Duration) *ImageUntagLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the image untag libpod params
func (o *ImageUntagLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the image untag libpod params
func (o *ImageUntagLibpodParams) WithContext(ctx context.Context) *ImageUntagLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the image untag libpod params
func (o *ImageUntagLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the image untag libpod params
func (o *ImageUntagLibpodParams) WithHTTPClient(client *http.Client) *ImageUntagLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the image untag libpod params
func (o *ImageUntagLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the image untag libpod params
func (o *ImageUntagLibpodParams) WithName(name string) *ImageUntagLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the image untag libpod params
func (o *ImageUntagLibpodParams) SetName(name string) {
	o.Name = name
}

// WithRepo adds the repo to the image untag libpod params
func (o *ImageUntagLibpodParams) WithRepo(repo *string) *ImageUntagLibpodParams {
	o.SetRepo(repo)
	return o
}

// SetRepo adds the repo to the image untag libpod params
func (o *ImageUntagLibpodParams) SetRepo(repo *string) {
	o.Repo = repo
}

// WithTag adds the tag to the image untag libpod params
func (o *ImageUntagLibpodParams) WithTag(tag *string) *ImageUntagLibpodParams {
	o.SetTag(tag)
	return o
}

// SetTag adds the tag to the image untag libpod params
func (o *ImageUntagLibpodParams) SetTag(tag *string) {
	o.Tag = tag
}

// WriteToRequest writes these params to a swagger request
func (o *ImageUntagLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.Repo != nil {

		// query param repo
		var qrRepo string

		if o.Repo != nil {
			qrRepo = *o.Repo
		}
		qRepo := qrRepo
		if qRepo != "" {

			if err := r.SetQueryParam("repo", qRepo); err != nil {
				return err
			}
		}
	}

	if o.Tag != nil {

		// query param tag
		var qrTag string

		if o.Tag != nil {
			qrTag = *o.Tag
		}
		qTag := qrTag
		if qTag != "" {

			if err := r.SetQueryParam("tag", qTag); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
