// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewImageTreeLibpodParams creates a new ImageTreeLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewImageTreeLibpodParams() *ImageTreeLibpodParams {
	return &ImageTreeLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewImageTreeLibpodParamsWithTimeout creates a new ImageTreeLibpodParams object
// with the ability to set a timeout on a request.
func NewImageTreeLibpodParamsWithTimeout(timeout time.Duration) *ImageTreeLibpodParams {
	return &ImageTreeLibpodParams{
		timeout: timeout,
	}
}

// NewImageTreeLibpodParamsWithContext creates a new ImageTreeLibpodParams object
// with the ability to set a context for a request.
func NewImageTreeLibpodParamsWithContext(ctx context.Context) *ImageTreeLibpodParams {
	return &ImageTreeLibpodParams{
		Context: ctx,
	}
}

// NewImageTreeLibpodParamsWithHTTPClient creates a new ImageTreeLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewImageTreeLibpodParamsWithHTTPClient(client *http.Client) *ImageTreeLibpodParams {
	return &ImageTreeLibpodParams{
		HTTPClient: client,
	}
}

/*
ImageTreeLibpodParams contains all the parameters to send to the API endpoint

	for the image tree libpod operation.

	Typically these are written to a http.Request.
*/
type ImageTreeLibpodParams struct {

	/* Name.

	   the name or ID of the container
	*/
	Name string

	/* Whatrequires.

	   show all child images and layers of the specified image
	*/
	Whatrequires *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the image tree libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageTreeLibpodParams) WithDefaults() *ImageTreeLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the image tree libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImageTreeLibpodParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the image tree libpod params
func (o *ImageTreeLibpodParams) WithTimeout(timeout time.Duration) *ImageTreeLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the image tree libpod params
func (o *ImageTreeLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the image tree libpod params
func (o *ImageTreeLibpodParams) WithContext(ctx context.Context) *ImageTreeLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the image tree libpod params
func (o *ImageTreeLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the image tree libpod params
func (o *ImageTreeLibpodParams) WithHTTPClient(client *http.Client) *ImageTreeLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the image tree libpod params
func (o *ImageTreeLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the image tree libpod params
func (o *ImageTreeLibpodParams) WithName(name string) *ImageTreeLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the image tree libpod params
func (o *ImageTreeLibpodParams) SetName(name string) {
	o.Name = name
}

// WithWhatrequires adds the whatrequires to the image tree libpod params
func (o *ImageTreeLibpodParams) WithWhatrequires(whatrequires *bool) *ImageTreeLibpodParams {
	o.SetWhatrequires(whatrequires)
	return o
}

// SetWhatrequires adds the whatrequires to the image tree libpod params
func (o *ImageTreeLibpodParams) SetWhatrequires(whatrequires *bool) {
	o.Whatrequires = whatrequires
}

// WriteToRequest writes these params to a swagger request
func (o *ImageTreeLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.Whatrequires != nil {

		// query param whatrequires
		var qrWhatrequires bool

		if o.Whatrequires != nil {
			qrWhatrequires = *o.Whatrequires
		}
		qWhatrequires := swag.FormatBool(qrWhatrequires)
		if qWhatrequires != "" {

			if err := r.SetQueryParam("whatrequires", qWhatrequires); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
