// Code generated by go-swagger; DO NOT EDIT.

package networks

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new networks API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for networks API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	NetworkConnectLibpod(params *NetworkConnectLibpodParams, opts ...ClientOption) (*NetworkConnectLibpodOK, error)

	NetworkCreateLibpod(params *NetworkCreateLibpodParams, opts ...ClientOption) (*NetworkCreateLibpodOK, error)

	NetworkDeleteLibpod(params *NetworkDeleteLibpodParams, opts ...ClientOption) (*NetworkDeleteLibpodOK, error)

	NetworkDisconnectLibpod(params *NetworkDisconnectLibpodParams, opts ...ClientOption) (*NetworkDisconnectLibpodOK, error)

	NetworkExistsLibpod(params *NetworkExistsLibpodParams, opts ...ClientOption) (*NetworkExistsLibpodNoContent, error)

	NetworkInspectLibpod(params *NetworkInspectLibpodParams, opts ...ClientOption) (*NetworkInspectLibpodOK, error)

	NetworkListLibpod(params *NetworkListLibpodParams, opts ...ClientOption) (*NetworkListLibpodOK, error)

	NetworkPruneLibpod(params *NetworkPruneLibpodParams, opts ...ClientOption) (*NetworkPruneLibpodOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
NetworkConnectLibpod connects container to network

Connect a container to a network.
*/
func (a *Client) NetworkConnectLibpod(params *NetworkConnectLibpodParams, opts ...ClientOption) (*NetworkConnectLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkConnectLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "NetworkConnectLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/networks/{name}/connect",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &NetworkConnectLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkConnectLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for NetworkConnectLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
NetworkCreateLibpod creates network

Create a new network configuration
*/
func (a *Client) NetworkCreateLibpod(params *NetworkCreateLibpodParams, opts ...ClientOption) (*NetworkCreateLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkCreateLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "NetworkCreateLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/networks/create",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &NetworkCreateLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkCreateLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for NetworkCreateLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
NetworkDeleteLibpod removes a network

Remove a CNI configured network
*/
func (a *Client) NetworkDeleteLibpod(params *NetworkDeleteLibpodParams, opts ...ClientOption) (*NetworkDeleteLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkDeleteLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "NetworkDeleteLibpod",
		Method:             "DELETE",
		PathPattern:        "/libpod/networks/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &NetworkDeleteLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkDeleteLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for NetworkDeleteLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
NetworkDisconnectLibpod disconnects container from network

Disconnect a container from a network.
*/
func (a *Client) NetworkDisconnectLibpod(params *NetworkDisconnectLibpodParams, opts ...ClientOption) (*NetworkDisconnectLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkDisconnectLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "NetworkDisconnectLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/networks/{name}/disconnect",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &NetworkDisconnectLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkDisconnectLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for NetworkDisconnectLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
NetworkExistsLibpod networks exists

Check if network exists
*/
func (a *Client) NetworkExistsLibpod(params *NetworkExistsLibpodParams, opts ...ClientOption) (*NetworkExistsLibpodNoContent, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkExistsLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "NetworkExistsLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/networks/{name}/exists",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &NetworkExistsLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkExistsLibpodNoContent)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for NetworkExistsLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
NetworkInspectLibpod inspects a network

Display low level configuration for a CNI network.
- In a 200 response, all of the fields named Bytes are returned as a Base64 encoded string.
*/
func (a *Client) NetworkInspectLibpod(params *NetworkInspectLibpodParams, opts ...ClientOption) (*NetworkInspectLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkInspectLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "NetworkInspectLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/networks/{name}/json",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &NetworkInspectLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkInspectLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for NetworkInspectLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
NetworkListLibpod lists networks

Display summary of network configurations.
- In a 200 response, all of the fields named Bytes are returned as a Base64 encoded string.
*/
func (a *Client) NetworkListLibpod(params *NetworkListLibpodParams, opts ...ClientOption) (*NetworkListLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkListLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "NetworkListLibpod",
		Method:             "GET",
		PathPattern:        "/libpod/networks/json",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &NetworkListLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkListLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for NetworkListLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
NetworkPruneLibpod deletes unused networks

Remove CNI networks that do not have containers
*/
func (a *Client) NetworkPruneLibpod(params *NetworkPruneLibpodParams, opts ...ClientOption) (*NetworkPruneLibpodOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkPruneLibpodParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "NetworkPruneLibpod",
		Method:             "POST",
		PathPattern:        "/libpod/networks/prune",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json", "application/x-tar"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &NetworkPruneLibpodReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkPruneLibpodOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for NetworkPruneLibpod: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
