#debuginfo not supported with Go
%global debug_package %{nil}

%global goipath         github.com/skupperproject/skupper/cmd/skupper
Version:                1.8.2
%global buildnum        1
%global downstream_build -rh-%{buildnum}
%global tag             1.8.2
%global package_name    skupper-cli
%global binary_name     skupper
%global golang_version  1.21
%global LDFLAGS         "-X github.com/skupperproject/skupper/pkg/version.Version=%{version}%{downstream_build}"


%gometa

%global godocs          README.md

Name:           %{package_name}
Release:        %{buildnum}%{?dist}
Summary:        Skupper command line tool

License:        ASL 2.0

URL:            %{gourl}
Source0:        skupper-%{version}.tar.gz
Source1:        vendor-%{version}.tar.gz
Source2:        images.go
Source3:        labels.go
#Source4:        podman-update-patch.diff

BuildRequires:  golang >= %{golang_version}
Provides:       %{package_name}

ExclusiveArch:    x86_64 aarch64 ppc64le s390x

%description
The Skupper client is a CLI tool to create virtual application networks (VANs)

%package redistributable
Summary:        Skupper command line tool
BuildRequires:  golang >= %{golang_version}
Provides:       %{package_name}

%description redistributable
The Skupper client is a CLI tool to create virtual application networks (VANs)

%prep
%setup -q -n skupper-%{version}
tar xpf %{SOURCE1} -C .
cp %{SOURCE2} pkg/images
cp %{SOURCE3} client/
#patch -p1 < %{SOURCE4}

%build
%ifarch x86_64
GOOS=linux
GOARCH=amd64
%endif
%ifarch ppc64le
GOOS=linux
GOARCH=ppc64le
%endif
%ifarch %{arm} aarch64
GOOS=linux
GOARCH=arm64
%endif
%ifarch s390x
GOOS=linux
GOARCH=s390x
%endif
make generate-client
go build -mod=vendor -ldflags=%{LDFLAGS} -o build/bin/skupper-linux-${GOARCH} %{goipath}

%ifarch x86_64
# create binaries fo all supported arches
export CGO_ENABLED=0
GOOS=windows GOARCH=amd64 go build -buildmode=pie -mod=vendor -ldflags=%{LDFLAGS} -o build/bin/skupper-windows-amd64 %{goipath}
GOOS=windows GOARCH=arm64 go build -buildmode=pie -mod=vendor -ldflags=%{LDFLAGS} -o build/bin/skupper-windows-arm64 %{goipath}
GOOS=darwin GOARCH=amd64 go build -buildmode=pie -mod=vendor -ldflags=%{LDFLAGS} -o build/bin/skupper-darwin-amd64 %{goipath}
GOOS=darwin GOARCH=arm64 go build -buildmode=pie -mod=vendor -ldflags=%{LDFLAGS} -o build/bin/skupper-darwin-arm64 %{goipath}
%endif 

%install
install -m 0755 -vd %{buildroot}%{_bindir}

%ifarch x86_64
install -p -m 0755 build/bin/skupper-linux-amd64 %{buildroot}%{_bindir}/skupper
install -d %{buildroot}%{_datadir}/%{name}/{linux,macosx,windows}
install -p -m 755 build/bin/skupper-linux-amd64 %{buildroot}%{_datadir}/%{name}/linux/skupper
install -p -m 755 build/bin/skupper-darwin-amd64 %{buildroot}/%{_datadir}/%{name}/macosx/skupper
install -p -m 755 build/bin/skupper-windows-amd64 %{buildroot}/%{_datadir}/%{name}/windows/skupper.exe
%endif

%ifarch aarch64
install -m 0755 build/bin/skupper-linux-arm64 %{buildroot}%{_bindir}/skupper

install -d %{buildroot}%{_datadir}/%{name}/linux
install -p -m 755 build/bin/skupper-linux-arm64 %{buildroot}/%{_datadir}/%{name}/linux/skupper
%endif

%ifarch ppc64le
install -m 0755 build/bin/skupper-linux-ppc64le %{buildroot}%{_bindir}/skupper

install -d %{buildroot}%{_datadir}/%{name}/linux
install -p -m 755 build/bin/skupper-linux-ppc64le %{buildroot}/%{_datadir}/%{name}/linux/skupper
%endif

%ifarch s390x
install -m 0755 build/bin/skupper-linux-s390x %{buildroot}%{_bindir}/skupper

install -d %{buildroot}%{_datadir}/%{name}/linux
install -p -m 755 build/bin/skupper-linux-s390x %{buildroot}/%{_datadir}/%{name}/linux/skupper
%endif

%files
%license LICENSE
%doc README.md
%{_bindir}/skupper

%ifarch x86_64
%files redistributable
%license LICENSE
%{_datadir}/%{name}/linux/skupper
%{_datadir}/%{name}/macosx/skupper
%{_datadir}/%{name}/windows/skupper.exe
%endif

%ifarch ppc64le
%files redistributable
%license LICENSE
%{_datadir}/%{name}/linux/skupper
%endif

%ifarch s390x
%files redistributable
%license LICENSE
%{_datadir}/%{name}/linux/skupper
%endif

%ifarch aarch64
%files redistributable
%license LICENSE
%{_datadir}/%{name}/linux/skupper
%endif

%changelog
