// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// Mount Mount represents a mount (volume).
//
// swagger:model Mount
type Mount struct {

	// bind options
	BindOptions *BindOptions `json:"BindOptions,omitempty"`

	// consistency
	Consistency Consistency `json:"Consistency,omitempty"`

	// destination
	Destination string `json:"Destination,omitempty"`

	// options
	Options []string `json:"Options"`

	// read only
	ReadOnly bool `json:"ReadOnly,omitempty"`

	// Source specifies the name of the mount. Depending on mount type, this
	// may be a volume name or a host path, or even ignored.
	// Source is not supported for tmpfs (must be an empty value)
	Source string `json:"Source,omitempty"`

	// target
	Target string `json:"Target,omitempty"`

	// tmpfs options
	TmpfsOptions *TmpfsOptions `json:"TmpfsOptions,omitempty"`

	// type
	Type Type `json:"Type,omitempty"`

	// volume options
	VolumeOptions *VolumeOptions `json:"VolumeOptions,omitempty"`
}

// Validate validates this mount
func (m *Mount) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBindOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConsistency(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTmpfsOptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVolumeOptions(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Mount) validateBindOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.BindOptions) { // not required
		return nil
	}

	if m.BindOptions != nil {
		if err := m.BindOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("BindOptions")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("BindOptions")
			}
			return err
		}
	}

	return nil
}

func (m *Mount) validateConsistency(formats strfmt.Registry) error {
	if swag.IsZero(m.Consistency) { // not required
		return nil
	}

	if err := m.Consistency.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Consistency")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Consistency")
		}
		return err
	}

	return nil
}

func (m *Mount) validateTmpfsOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.TmpfsOptions) { // not required
		return nil
	}

	if m.TmpfsOptions != nil {
		if err := m.TmpfsOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("TmpfsOptions")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("TmpfsOptions")
			}
			return err
		}
	}

	return nil
}

func (m *Mount) validateType(formats strfmt.Registry) error {
	if swag.IsZero(m.Type) { // not required
		return nil
	}

	if err := m.Type.Validate(formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Type")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Type")
		}
		return err
	}

	return nil
}

func (m *Mount) validateVolumeOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.VolumeOptions) { // not required
		return nil
	}

	if m.VolumeOptions != nil {
		if err := m.VolumeOptions.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("VolumeOptions")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("VolumeOptions")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this mount based on the context it is used
func (m *Mount) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBindOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateConsistency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTmpfsOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVolumeOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Mount) contextValidateBindOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.BindOptions != nil {
		if err := m.BindOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("BindOptions")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("BindOptions")
			}
			return err
		}
	}

	return nil
}

func (m *Mount) contextValidateConsistency(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Consistency.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Consistency")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Consistency")
		}
		return err
	}

	return nil
}

func (m *Mount) contextValidateTmpfsOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.TmpfsOptions != nil {
		if err := m.TmpfsOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("TmpfsOptions")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("TmpfsOptions")
			}
			return err
		}
	}

	return nil
}

func (m *Mount) contextValidateType(ctx context.Context, formats strfmt.Registry) error {

	if err := m.Type.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("Type")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("Type")
		}
		return err
	}

	return nil
}

func (m *Mount) contextValidateVolumeOptions(ctx context.Context, formats strfmt.Registry) error {

	if m.VolumeOptions != nil {
		if err := m.VolumeOptions.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("VolumeOptions")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("VolumeOptions")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Mount) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Mount) UnmarshalBinary(b []byte) error {
	var res Mount
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
