// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// ContainerInspectLibpodReader is a Reader for the ContainerInspectLibpod structure.
type ContainerInspectLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerInspectLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewContainerInspectLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewContainerInspectLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerInspectLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerInspectLibpodOK creates a ContainerInspectLibpodOK with default headers values
func NewContainerInspectLibpodOK() *ContainerInspectLibpodOK {
	return &ContainerInspectLibpodOK{}
}

/*
ContainerInspectLibpodOK describes a response with status code 200, with default header values.

Inspect container
*/
type ContainerInspectLibpodOK struct {
	Payload *ContainerInspectLibpodOKBody
}

// IsSuccess returns true when this container inspect libpod o k response has a 2xx status code
func (o *ContainerInspectLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container inspect libpod o k response has a 3xx status code
func (o *ContainerInspectLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container inspect libpod o k response has a 4xx status code
func (o *ContainerInspectLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this container inspect libpod o k response has a 5xx status code
func (o *ContainerInspectLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this container inspect libpod o k response a status code equal to that given
func (o *ContainerInspectLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ContainerInspectLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/json][%d] containerInspectLibpodOK  %+v", 200, o.Payload)
}

func (o *ContainerInspectLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/json][%d] containerInspectLibpodOK  %+v", 200, o.Payload)
}

func (o *ContainerInspectLibpodOK) GetPayload() *ContainerInspectLibpodOKBody {
	return o.Payload
}

func (o *ContainerInspectLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerInspectLibpodOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerInspectLibpodNotFound creates a ContainerInspectLibpodNotFound with default headers values
func NewContainerInspectLibpodNotFound() *ContainerInspectLibpodNotFound {
	return &ContainerInspectLibpodNotFound{}
}

/*
ContainerInspectLibpodNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerInspectLibpodNotFound struct {
	Payload *ContainerInspectLibpodNotFoundBody
}

// IsSuccess returns true when this container inspect libpod not found response has a 2xx status code
func (o *ContainerInspectLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container inspect libpod not found response has a 3xx status code
func (o *ContainerInspectLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container inspect libpod not found response has a 4xx status code
func (o *ContainerInspectLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container inspect libpod not found response has a 5xx status code
func (o *ContainerInspectLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container inspect libpod not found response a status code equal to that given
func (o *ContainerInspectLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerInspectLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/json][%d] containerInspectLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerInspectLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/json][%d] containerInspectLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerInspectLibpodNotFound) GetPayload() *ContainerInspectLibpodNotFoundBody {
	return o.Payload
}

func (o *ContainerInspectLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerInspectLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerInspectLibpodInternalServerError creates a ContainerInspectLibpodInternalServerError with default headers values
func NewContainerInspectLibpodInternalServerError() *ContainerInspectLibpodInternalServerError {
	return &ContainerInspectLibpodInternalServerError{}
}

/*
ContainerInspectLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerInspectLibpodInternalServerError struct {
	Payload *ContainerInspectLibpodInternalServerErrorBody
}

// IsSuccess returns true when this container inspect libpod internal server error response has a 2xx status code
func (o *ContainerInspectLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container inspect libpod internal server error response has a 3xx status code
func (o *ContainerInspectLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container inspect libpod internal server error response has a 4xx status code
func (o *ContainerInspectLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container inspect libpod internal server error response has a 5xx status code
func (o *ContainerInspectLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container inspect libpod internal server error response a status code equal to that given
func (o *ContainerInspectLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerInspectLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/json][%d] containerInspectLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerInspectLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/containers/{name}/json][%d] containerInspectLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerInspectLibpodInternalServerError) GetPayload() *ContainerInspectLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerInspectLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerInspectLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerInspectLibpodInternalServerErrorBody container inspect libpod internal server error body
swagger:model ContainerInspectLibpodInternalServerErrorBody
*/
type ContainerInspectLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container inspect libpod internal server error body
func (o *ContainerInspectLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container inspect libpod internal server error body based on context it is used
func (o *ContainerInspectLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerInspectLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerInspectLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerInspectLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerInspectLibpodNotFoundBody container inspect libpod not found body
swagger:model ContainerInspectLibpodNotFoundBody
*/
type ContainerInspectLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container inspect libpod not found body
func (o *ContainerInspectLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container inspect libpod not found body based on context it is used
func (o *ContainerInspectLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerInspectLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerInspectLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerInspectLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerInspectLibpodOKBody container inspect libpod o k body
swagger:model ContainerInspectLibpodOKBody
*/
type ContainerInspectLibpodOKBody struct {

	// app armor profile
	AppArmorProfile string `json:"AppArmorProfile,omitempty"`

	// args
	Args []string `json:"Args"`

	// bounding caps
	BoundingCaps []string `json:"BoundingCaps"`

	// config
	Config *models.InspectContainerConfig `json:"Config,omitempty"`

	// conmon pid file
	ConmonPidFile string `json:"ConmonPidFile,omitempty"`

	// created
	// Format: date-time
	Created strfmt.DateTime `json:"Created,omitempty"`

	// dependencies
	Dependencies []string `json:"Dependencies"`

	// driver
	Driver string `json:"Driver,omitempty"`

	// effective caps
	EffectiveCaps []string `json:"EffectiveCaps"`

	// exec i ds
	ExecIDs []string `json:"ExecIDs"`

	// graph driver
	GraphDriver *models.DriverData `json:"GraphDriver,omitempty"`

	// host config
	HostConfig *models.InspectContainerHostConfig `json:"HostConfig,omitempty"`

	// hostname path
	HostnamePath string `json:"HostnamePath,omitempty"`

	// hosts path
	HostsPath string `json:"HostsPath,omitempty"`

	// ID
	ID string `json:"Id,omitempty"`

	// image
	Image string `json:"Image,omitempty"`

	// image name
	ImageName string `json:"ImageName,omitempty"`

	// is infra
	IsInfra bool `json:"IsInfra,omitempty"`

	// mount label
	MountLabel string `json:"MountLabel,omitempty"`

	// mounts
	Mounts []*models.InspectMount `json:"Mounts"`

	// name
	Name string `json:"Name,omitempty"`

	// namespace
	Namespace string `json:"Namespace,omitempty"`

	// network settings
	NetworkSettings *models.InspectNetworkSettings `json:"NetworkSettings,omitempty"`

	// o c i config path
	OCIConfigPath string `json:"OCIConfigPath,omitempty"`

	// o c i runtime
	OCIRuntime string `json:"OCIRuntime,omitempty"`

	// path
	Path string `json:"Path,omitempty"`

	// pid file
	PidFile string `json:"PidFile,omitempty"`

	// pod
	Pod string `json:"Pod,omitempty"`

	// process label
	ProcessLabel string `json:"ProcessLabel,omitempty"`

	// resolv conf path
	ResolvConfPath string `json:"ResolvConfPath,omitempty"`

	// restart count
	RestartCount int32 `json:"RestartCount,omitempty"`

	// rootfs
	Rootfs string `json:"Rootfs,omitempty"`

	// size root fs
	SizeRootFs int64 `json:"SizeRootFs,omitempty"`

	// size rw
	SizeRw int64 `json:"SizeRw,omitempty"`

	// state
	State *models.InspectContainerState `json:"State,omitempty"`

	// static dir
	StaticDir string `json:"StaticDir,omitempty"`
}

// Validate validates this container inspect libpod o k body
func (o *ContainerInspectLibpodOKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreated(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGraphDriver(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHostConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMounts(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNetworkSettings(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ContainerInspectLibpodOKBody) validateConfig(formats strfmt.Registry) error {
	if swag.IsZero(o.Config) { // not required
		return nil
	}

	if o.Config != nil {
		if err := o.Config.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("containerInspectLibpodOK" + "." + "Config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("containerInspectLibpodOK" + "." + "Config")
			}
			return err
		}
	}

	return nil
}

func (o *ContainerInspectLibpodOKBody) validateCreated(formats strfmt.Registry) error {
	if swag.IsZero(o.Created) { // not required
		return nil
	}

	if err := validate.FormatOf("containerInspectLibpodOK"+"."+"Created", "body", "date-time", o.Created.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *ContainerInspectLibpodOKBody) validateGraphDriver(formats strfmt.Registry) error {
	if swag.IsZero(o.GraphDriver) { // not required
		return nil
	}

	if o.GraphDriver != nil {
		if err := o.GraphDriver.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("containerInspectLibpodOK" + "." + "GraphDriver")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("containerInspectLibpodOK" + "." + "GraphDriver")
			}
			return err
		}
	}

	return nil
}

func (o *ContainerInspectLibpodOKBody) validateHostConfig(formats strfmt.Registry) error {
	if swag.IsZero(o.HostConfig) { // not required
		return nil
	}

	if o.HostConfig != nil {
		if err := o.HostConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("containerInspectLibpodOK" + "." + "HostConfig")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("containerInspectLibpodOK" + "." + "HostConfig")
			}
			return err
		}
	}

	return nil
}

func (o *ContainerInspectLibpodOKBody) validateMounts(formats strfmt.Registry) error {
	if swag.IsZero(o.Mounts) { // not required
		return nil
	}

	for i := 0; i < len(o.Mounts); i++ {
		if swag.IsZero(o.Mounts[i]) { // not required
			continue
		}

		if o.Mounts[i] != nil {
			if err := o.Mounts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("containerInspectLibpodOK" + "." + "Mounts" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("containerInspectLibpodOK" + "." + "Mounts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ContainerInspectLibpodOKBody) validateNetworkSettings(formats strfmt.Registry) error {
	if swag.IsZero(o.NetworkSettings) { // not required
		return nil
	}

	if o.NetworkSettings != nil {
		if err := o.NetworkSettings.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("containerInspectLibpodOK" + "." + "NetworkSettings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("containerInspectLibpodOK" + "." + "NetworkSettings")
			}
			return err
		}
	}

	return nil
}

func (o *ContainerInspectLibpodOKBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	if o.State != nil {
		if err := o.State.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("containerInspectLibpodOK" + "." + "State")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("containerInspectLibpodOK" + "." + "State")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container inspect libpod o k body based on the context it is used
func (o *ContainerInspectLibpodOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGraphDriver(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHostConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNetworkSettings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ContainerInspectLibpodOKBody) contextValidateConfig(ctx context.Context, formats strfmt.Registry) error {

	if o.Config != nil {
		if err := o.Config.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("containerInspectLibpodOK" + "." + "Config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("containerInspectLibpodOK" + "." + "Config")
			}
			return err
		}
	}

	return nil
}

func (o *ContainerInspectLibpodOKBody) contextValidateGraphDriver(ctx context.Context, formats strfmt.Registry) error {

	if o.GraphDriver != nil {
		if err := o.GraphDriver.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("containerInspectLibpodOK" + "." + "GraphDriver")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("containerInspectLibpodOK" + "." + "GraphDriver")
			}
			return err
		}
	}

	return nil
}

func (o *ContainerInspectLibpodOKBody) contextValidateHostConfig(ctx context.Context, formats strfmt.Registry) error {

	if o.HostConfig != nil {
		if err := o.HostConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("containerInspectLibpodOK" + "." + "HostConfig")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("containerInspectLibpodOK" + "." + "HostConfig")
			}
			return err
		}
	}

	return nil
}

func (o *ContainerInspectLibpodOKBody) contextValidateMounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Mounts); i++ {

		if o.Mounts[i] != nil {
			if err := o.Mounts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("containerInspectLibpodOK" + "." + "Mounts" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("containerInspectLibpodOK" + "." + "Mounts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ContainerInspectLibpodOKBody) contextValidateNetworkSettings(ctx context.Context, formats strfmt.Registry) error {

	if o.NetworkSettings != nil {
		if err := o.NetworkSettings.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("containerInspectLibpodOK" + "." + "NetworkSettings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("containerInspectLibpodOK" + "." + "NetworkSettings")
			}
			return err
		}
	}

	return nil
}

func (o *ContainerInspectLibpodOKBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if o.State != nil {
		if err := o.State.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("containerInspectLibpodOK" + "." + "State")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("containerInspectLibpodOK" + "." + "State")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ContainerInspectLibpodOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerInspectLibpodOKBody) UnmarshalBinary(b []byte) error {
	var res ContainerInspectLibpodOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
