// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// ContainerListLibpodReader is a Reader for the ContainerListLibpod structure.
type ContainerListLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerListLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewContainerListLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewContainerListLibpodBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerListLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerListLibpodOK creates a ContainerListLibpodOK with default headers values
func NewContainerListLibpodOK() *ContainerListLibpodOK {
	return &ContainerListLibpodOK{}
}

/*
ContainerListLibpodOK describes a response with status code 200, with default header values.

List Containers
*/
type ContainerListLibpodOK struct {
	Payload []*models.ListContainer
}

// IsSuccess returns true when this container list libpod o k response has a 2xx status code
func (o *ContainerListLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container list libpod o k response has a 3xx status code
func (o *ContainerListLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container list libpod o k response has a 4xx status code
func (o *ContainerListLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this container list libpod o k response has a 5xx status code
func (o *ContainerListLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this container list libpod o k response a status code equal to that given
func (o *ContainerListLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ContainerListLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/json][%d] containerListLibpodOK  %+v", 200, o.Payload)
}

func (o *ContainerListLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/containers/json][%d] containerListLibpodOK  %+v", 200, o.Payload)
}

func (o *ContainerListLibpodOK) GetPayload() []*models.ListContainer {
	return o.Payload
}

func (o *ContainerListLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerListLibpodBadRequest creates a ContainerListLibpodBadRequest with default headers values
func NewContainerListLibpodBadRequest() *ContainerListLibpodBadRequest {
	return &ContainerListLibpodBadRequest{}
}

/*
ContainerListLibpodBadRequest describes a response with status code 400, with default header values.

Bad parameter in request
*/
type ContainerListLibpodBadRequest struct {
	Payload *ContainerListLibpodBadRequestBody
}

// IsSuccess returns true when this container list libpod bad request response has a 2xx status code
func (o *ContainerListLibpodBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container list libpod bad request response has a 3xx status code
func (o *ContainerListLibpodBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container list libpod bad request response has a 4xx status code
func (o *ContainerListLibpodBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this container list libpod bad request response has a 5xx status code
func (o *ContainerListLibpodBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this container list libpod bad request response a status code equal to that given
func (o *ContainerListLibpodBadRequest) IsCode(code int) bool {
	return code == 400
}

func (o *ContainerListLibpodBadRequest) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/json][%d] containerListLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *ContainerListLibpodBadRequest) String() string {
	return fmt.Sprintf("[GET /libpod/containers/json][%d] containerListLibpodBadRequest  %+v", 400, o.Payload)
}

func (o *ContainerListLibpodBadRequest) GetPayload() *ContainerListLibpodBadRequestBody {
	return o.Payload
}

func (o *ContainerListLibpodBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerListLibpodBadRequestBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerListLibpodInternalServerError creates a ContainerListLibpodInternalServerError with default headers values
func NewContainerListLibpodInternalServerError() *ContainerListLibpodInternalServerError {
	return &ContainerListLibpodInternalServerError{}
}

/*
ContainerListLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerListLibpodInternalServerError struct {
	Payload *ContainerListLibpodInternalServerErrorBody
}

// IsSuccess returns true when this container list libpod internal server error response has a 2xx status code
func (o *ContainerListLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container list libpod internal server error response has a 3xx status code
func (o *ContainerListLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container list libpod internal server error response has a 4xx status code
func (o *ContainerListLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container list libpod internal server error response has a 5xx status code
func (o *ContainerListLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container list libpod internal server error response a status code equal to that given
func (o *ContainerListLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerListLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/containers/json][%d] containerListLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerListLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/containers/json][%d] containerListLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerListLibpodInternalServerError) GetPayload() *ContainerListLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerListLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerListLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerListLibpodBadRequestBody container list libpod bad request body
swagger:model ContainerListLibpodBadRequestBody
*/
type ContainerListLibpodBadRequestBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container list libpod bad request body
func (o *ContainerListLibpodBadRequestBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container list libpod bad request body based on context it is used
func (o *ContainerListLibpodBadRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerListLibpodBadRequestBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerListLibpodBadRequestBody) UnmarshalBinary(b []byte) error {
	var res ContainerListLibpodBadRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerListLibpodInternalServerErrorBody container list libpod internal server error body
swagger:model ContainerListLibpodInternalServerErrorBody
*/
type ContainerListLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container list libpod internal server error body
func (o *ContainerListLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container list libpod internal server error body based on context it is used
func (o *ContainerListLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerListLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerListLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerListLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
