// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerUnpauseLibpodReader is a Reader for the ContainerUnpauseLibpod structure.
type ContainerUnpauseLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ContainerUnpauseLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewContainerUnpauseLibpodNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewContainerUnpauseLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerUnpauseLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerUnpauseLibpodNoContent creates a ContainerUnpauseLibpodNoContent with default headers values
func NewContainerUnpauseLibpodNoContent() *ContainerUnpauseLibpodNoContent {
	return &ContainerUnpauseLibpodNoContent{}
}

/*
ContainerUnpauseLibpodNoContent describes a response with status code 204, with default header values.

no error
*/
type ContainerUnpauseLibpodNoContent struct {
}

// IsSuccess returns true when this container unpause libpod no content response has a 2xx status code
func (o *ContainerUnpauseLibpodNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container unpause libpod no content response has a 3xx status code
func (o *ContainerUnpauseLibpodNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container unpause libpod no content response has a 4xx status code
func (o *ContainerUnpauseLibpodNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this container unpause libpod no content response has a 5xx status code
func (o *ContainerUnpauseLibpodNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this container unpause libpod no content response a status code equal to that given
func (o *ContainerUnpauseLibpodNoContent) IsCode(code int) bool {
	return code == 204
}

func (o *ContainerUnpauseLibpodNoContent) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/unpause][%d] containerUnpauseLibpodNoContent ", 204)
}

func (o *ContainerUnpauseLibpodNoContent) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/unpause][%d] containerUnpauseLibpodNoContent ", 204)
}

func (o *ContainerUnpauseLibpodNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewContainerUnpauseLibpodNotFound creates a ContainerUnpauseLibpodNotFound with default headers values
func NewContainerUnpauseLibpodNotFound() *ContainerUnpauseLibpodNotFound {
	return &ContainerUnpauseLibpodNotFound{}
}

/*
ContainerUnpauseLibpodNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerUnpauseLibpodNotFound struct {
	Payload *ContainerUnpauseLibpodNotFoundBody
}

// IsSuccess returns true when this container unpause libpod not found response has a 2xx status code
func (o *ContainerUnpauseLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container unpause libpod not found response has a 3xx status code
func (o *ContainerUnpauseLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container unpause libpod not found response has a 4xx status code
func (o *ContainerUnpauseLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container unpause libpod not found response has a 5xx status code
func (o *ContainerUnpauseLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container unpause libpod not found response a status code equal to that given
func (o *ContainerUnpauseLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerUnpauseLibpodNotFound) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/unpause][%d] containerUnpauseLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerUnpauseLibpodNotFound) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/unpause][%d] containerUnpauseLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ContainerUnpauseLibpodNotFound) GetPayload() *ContainerUnpauseLibpodNotFoundBody {
	return o.Payload
}

func (o *ContainerUnpauseLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerUnpauseLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerUnpauseLibpodInternalServerError creates a ContainerUnpauseLibpodInternalServerError with default headers values
func NewContainerUnpauseLibpodInternalServerError() *ContainerUnpauseLibpodInternalServerError {
	return &ContainerUnpauseLibpodInternalServerError{}
}

/*
ContainerUnpauseLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerUnpauseLibpodInternalServerError struct {
	Payload *ContainerUnpauseLibpodInternalServerErrorBody
}

// IsSuccess returns true when this container unpause libpod internal server error response has a 2xx status code
func (o *ContainerUnpauseLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container unpause libpod internal server error response has a 3xx status code
func (o *ContainerUnpauseLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container unpause libpod internal server error response has a 4xx status code
func (o *ContainerUnpauseLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container unpause libpod internal server error response has a 5xx status code
func (o *ContainerUnpauseLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container unpause libpod internal server error response a status code equal to that given
func (o *ContainerUnpauseLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerUnpauseLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/unpause][%d] containerUnpauseLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerUnpauseLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/containers/{name}/unpause][%d] containerUnpauseLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerUnpauseLibpodInternalServerError) GetPayload() *ContainerUnpauseLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerUnpauseLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerUnpauseLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerUnpauseLibpodInternalServerErrorBody container unpause libpod internal server error body
swagger:model ContainerUnpauseLibpodInternalServerErrorBody
*/
type ContainerUnpauseLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container unpause libpod internal server error body
func (o *ContainerUnpauseLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container unpause libpod internal server error body based on context it is used
func (o *ContainerUnpauseLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerUnpauseLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerUnpauseLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerUnpauseLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerUnpauseLibpodNotFoundBody container unpause libpod not found body
swagger:model ContainerUnpauseLibpodNotFoundBody
*/
type ContainerUnpauseLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container unpause libpod not found body
func (o *ContainerUnpauseLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container unpause libpod not found body based on context it is used
func (o *ContainerUnpauseLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerUnpauseLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerUnpauseLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerUnpauseLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
