// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewContainerWaitParams creates a new ContainerWaitParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerWaitParams() *ContainerWaitParams {
	return &ContainerWaitParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerWaitParamsWithTimeout creates a new ContainerWaitParams object
// with the ability to set a timeout on a request.
func NewContainerWaitParamsWithTimeout(timeout time.Duration) *ContainerWaitParams {
	return &ContainerWaitParams{
		timeout: timeout,
	}
}

// NewContainerWaitParamsWithContext creates a new ContainerWaitParams object
// with the ability to set a context for a request.
func NewContainerWaitParamsWithContext(ctx context.Context) *ContainerWaitParams {
	return &ContainerWaitParams{
		Context: ctx,
	}
}

// NewContainerWaitParamsWithHTTPClient creates a new ContainerWaitParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerWaitParamsWithHTTPClient(client *http.Client) *ContainerWaitParams {
	return &ContainerWaitParams{
		HTTPClient: client,
	}
}

/*
ContainerWaitParams contains all the parameters to send to the API endpoint

	for the container wait operation.

	Typically these are written to a http.Request.
*/
type ContainerWaitParams struct {

	/* Condition.

	   wait until container is to a given condition. default is stopped. valid conditions are:
	- configured
	- created
	- exited
	- paused
	- running
	- stopped

	*/
	Condition *string

	/* Interval.

	   Time Interval to wait before polling for completion.

	   Default: "250ms"
	*/
	Interval *string

	/* Name.

	   the name or ID of the container
	*/
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container wait params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerWaitParams) WithDefaults() *ContainerWaitParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container wait params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerWaitParams) SetDefaults() {
	var (
		intervalDefault = string("250ms")
	)

	val := ContainerWaitParams{
		Interval: &intervalDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the container wait params
func (o *ContainerWaitParams) WithTimeout(timeout time.Duration) *ContainerWaitParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container wait params
func (o *ContainerWaitParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container wait params
func (o *ContainerWaitParams) WithContext(ctx context.Context) *ContainerWaitParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container wait params
func (o *ContainerWaitParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container wait params
func (o *ContainerWaitParams) WithHTTPClient(client *http.Client) *ContainerWaitParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container wait params
func (o *ContainerWaitParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCondition adds the condition to the container wait params
func (o *ContainerWaitParams) WithCondition(condition *string) *ContainerWaitParams {
	o.SetCondition(condition)
	return o
}

// SetCondition adds the condition to the container wait params
func (o *ContainerWaitParams) SetCondition(condition *string) {
	o.Condition = condition
}

// WithInterval adds the interval to the container wait params
func (o *ContainerWaitParams) WithInterval(interval *string) *ContainerWaitParams {
	o.SetInterval(interval)
	return o
}

// SetInterval adds the interval to the container wait params
func (o *ContainerWaitParams) SetInterval(interval *string) {
	o.Interval = interval
}

// WithName adds the name to the container wait params
func (o *ContainerWaitParams) WithName(name string) *ContainerWaitParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container wait params
func (o *ContainerWaitParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerWaitParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Condition != nil {

		// query param condition
		var qrCondition string

		if o.Condition != nil {
			qrCondition = *o.Condition
		}
		qCondition := qrCondition
		if qCondition != "" {

			if err := r.SetQueryParam("condition", qCondition); err != nil {
				return err
			}
		}
	}

	if o.Interval != nil {

		// query param interval
		var qrInterval string

		if o.Interval != nil {
			qrInterval = *o.Interval
		}
		qInterval := qrInterval
		if qInterval != "" {

			if err := r.SetQueryParam("interval", qInterval); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
