// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewImagePushLibpodParams creates a new ImagePushLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewImagePushLibpodParams() *ImagePushLibpodParams {
	return &ImagePushLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewImagePushLibpodParamsWithTimeout creates a new ImagePushLibpodParams object
// with the ability to set a timeout on a request.
func NewImagePushLibpodParamsWithTimeout(timeout time.Duration) *ImagePushLibpodParams {
	return &ImagePushLibpodParams{
		timeout: timeout,
	}
}

// NewImagePushLibpodParamsWithContext creates a new ImagePushLibpodParams object
// with the ability to set a context for a request.
func NewImagePushLibpodParamsWithContext(ctx context.Context) *ImagePushLibpodParams {
	return &ImagePushLibpodParams{
		Context: ctx,
	}
}

// NewImagePushLibpodParamsWithHTTPClient creates a new ImagePushLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewImagePushLibpodParamsWithHTTPClient(client *http.Client) *ImagePushLibpodParams {
	return &ImagePushLibpodParams{
		HTTPClient: client,
	}
}

/*
ImagePushLibpodParams contains all the parameters to send to the API endpoint

	for the image push libpod operation.

	Typically these are written to a http.Request.
*/
type ImagePushLibpodParams struct {

	/* XRegistryAuth.

	   A base64-encoded auth configuration.
	*/
	XRegistryAuth *string

	/* Destination.

	   Allows for pushing the image to a different destination than the image refers to.
	*/
	Destination *string

	/* Name.

	   Name of image to push.
	*/
	Name string

	/* TLSVerify.

	   Require TLS verification.

	   Default: true
	*/
	TLSVerify *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the image push libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImagePushLibpodParams) WithDefaults() *ImagePushLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the image push libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ImagePushLibpodParams) SetDefaults() {
	var (
		tLSVerifyDefault = bool(true)
	)

	val := ImagePushLibpodParams{
		TLSVerify: &tLSVerifyDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the image push libpod params
func (o *ImagePushLibpodParams) WithTimeout(timeout time.Duration) *ImagePushLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the image push libpod params
func (o *ImagePushLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the image push libpod params
func (o *ImagePushLibpodParams) WithContext(ctx context.Context) *ImagePushLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the image push libpod params
func (o *ImagePushLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the image push libpod params
func (o *ImagePushLibpodParams) WithHTTPClient(client *http.Client) *ImagePushLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the image push libpod params
func (o *ImagePushLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithXRegistryAuth adds the xRegistryAuth to the image push libpod params
func (o *ImagePushLibpodParams) WithXRegistryAuth(xRegistryAuth *string) *ImagePushLibpodParams {
	o.SetXRegistryAuth(xRegistryAuth)
	return o
}

// SetXRegistryAuth adds the xRegistryAuth to the image push libpod params
func (o *ImagePushLibpodParams) SetXRegistryAuth(xRegistryAuth *string) {
	o.XRegistryAuth = xRegistryAuth
}

// WithDestination adds the destination to the image push libpod params
func (o *ImagePushLibpodParams) WithDestination(destination *string) *ImagePushLibpodParams {
	o.SetDestination(destination)
	return o
}

// SetDestination adds the destination to the image push libpod params
func (o *ImagePushLibpodParams) SetDestination(destination *string) {
	o.Destination = destination
}

// WithName adds the name to the image push libpod params
func (o *ImagePushLibpodParams) WithName(name string) *ImagePushLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the image push libpod params
func (o *ImagePushLibpodParams) SetName(name string) {
	o.Name = name
}

// WithTLSVerify adds the tLSVerify to the image push libpod params
func (o *ImagePushLibpodParams) WithTLSVerify(tLSVerify *bool) *ImagePushLibpodParams {
	o.SetTLSVerify(tLSVerify)
	return o
}

// SetTLSVerify adds the tlsVerify to the image push libpod params
func (o *ImagePushLibpodParams) SetTLSVerify(tLSVerify *bool) {
	o.TLSVerify = tLSVerify
}

// WriteToRequest writes these params to a swagger request
func (o *ImagePushLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.XRegistryAuth != nil {

		// header param X-Registry-Auth
		if err := r.SetHeaderParam("X-Registry-Auth", *o.XRegistryAuth); err != nil {
			return err
		}
	}

	if o.Destination != nil {

		// query param destination
		var qrDestination string

		if o.Destination != nil {
			qrDestination = *o.Destination
		}
		qDestination := qrDestination
		if qDestination != "" {

			if err := r.SetQueryParam("destination", qDestination); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.TLSVerify != nil {

		// query param tlsVerify
		var qrTLSVerify bool

		if o.TLSVerify != nil {
			qrTLSVerify = *o.TLSVerify
		}
		qTLSVerify := swag.FormatBool(qrTLSVerify)
		if qTLSVerify != "" {

			if err := r.SetQueryParam("tlsVerify", qTLSVerify); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
