// Code generated by go-swagger; DO NOT EDIT.

package system

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// SystemInfoLibpodReader is a Reader for the SystemInfoLibpod structure.
type SystemInfoLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SystemInfoLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSystemInfoLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewSystemInfoLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewSystemInfoLibpodOK creates a SystemInfoLibpodOK with default headers values
func NewSystemInfoLibpodOK() *SystemInfoLibpodOK {
	return &SystemInfoLibpodOK{}
}

/*
SystemInfoLibpodOK describes a response with status code 200, with default header values.

Info
*/
type SystemInfoLibpodOK struct {
	Payload *models.Info
}

// IsSuccess returns true when this system info libpod o k response has a 2xx status code
func (o *SystemInfoLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this system info libpod o k response has a 3xx status code
func (o *SystemInfoLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this system info libpod o k response has a 4xx status code
func (o *SystemInfoLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this system info libpod o k response has a 5xx status code
func (o *SystemInfoLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this system info libpod o k response a status code equal to that given
func (o *SystemInfoLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *SystemInfoLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/info][%d] systemInfoLibpodOK  %+v", 200, o.Payload)
}

func (o *SystemInfoLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/info][%d] systemInfoLibpodOK  %+v", 200, o.Payload)
}

func (o *SystemInfoLibpodOK) GetPayload() *models.Info {
	return o.Payload
}

func (o *SystemInfoLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Info)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSystemInfoLibpodInternalServerError creates a SystemInfoLibpodInternalServerError with default headers values
func NewSystemInfoLibpodInternalServerError() *SystemInfoLibpodInternalServerError {
	return &SystemInfoLibpodInternalServerError{}
}

/*
SystemInfoLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type SystemInfoLibpodInternalServerError struct {
	Payload *SystemInfoLibpodInternalServerErrorBody
}

// IsSuccess returns true when this system info libpod internal server error response has a 2xx status code
func (o *SystemInfoLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this system info libpod internal server error response has a 3xx status code
func (o *SystemInfoLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this system info libpod internal server error response has a 4xx status code
func (o *SystemInfoLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this system info libpod internal server error response has a 5xx status code
func (o *SystemInfoLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this system info libpod internal server error response a status code equal to that given
func (o *SystemInfoLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *SystemInfoLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/info][%d] systemInfoLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *SystemInfoLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/info][%d] systemInfoLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *SystemInfoLibpodInternalServerError) GetPayload() *SystemInfoLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *SystemInfoLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SystemInfoLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SystemInfoLibpodInternalServerErrorBody system info libpod internal server error body
swagger:model SystemInfoLibpodInternalServerErrorBody
*/
type SystemInfoLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this system info libpod internal server error body
func (o *SystemInfoLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this system info libpod internal server error body based on context it is used
func (o *SystemInfoLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SystemInfoLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SystemInfoLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res SystemInfoLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
