// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HostInfo HostInfo describes the libpod host
//
// swagger:model HostInfo
type HostInfo struct {

	// arch
	Arch string `json:"arch,omitempty"`

	// buildah version
	BuildahVersion string `json:"buildahVersion,omitempty"`

	// c p us
	CPUs int64 `json:"cpus,omitempty"`

	// cgroup controllers
	CgroupControllers []string `json:"cgroupControllers"`

	// cgroup manager
	CgroupManager string `json:"cgroupManager,omitempty"`

	// cgroups version
	CgroupsVersion string `json:"cgroupVersion,omitempty"`

	// event logger
	EventLogger string `json:"eventLogger,omitempty"`

	// hostname
	Hostname string `json:"hostname,omitempty"`

	// kernel
	Kernel string `json:"kernel,omitempty"`

	// linkmode
	Linkmode string `json:"linkmode,omitempty"`

	// log driver
	LogDriver string `json:"logDriver,omitempty"`

	// mem free
	MemFree int64 `json:"memFree,omitempty"`

	// mem total
	MemTotal int64 `json:"memTotal,omitempty"`

	// network backend
	NetworkBackend string `json:"networkBackend,omitempty"`

	// o s
	OS string `json:"os,omitempty"`

	// runtime info
	RuntimeInfo map[string]interface{} `json:"runtimeInfo,omitempty"`

	// ServiceIsRemote is true when the podman/libpod service is remote to the client
	ServiceIsRemote bool `json:"serviceIsRemote,omitempty"`

	// swap free
	SwapFree int64 `json:"swapFree,omitempty"`

	// swap total
	SwapTotal int64 `json:"swapTotal,omitempty"`

	// uptime
	Uptime string `json:"uptime,omitempty"`

	// conmon
	Conmon *ConmonInfo `json:"conmon,omitempty"`

	// distribution
	Distribution *DistributionInfo `json:"distribution,omitempty"`

	// id mappings
	IDMappings *IDMappings `json:"idMappings,omitempty"`

	// oci runtime
	OciRuntime *OCIRuntimeInfo `json:"ociRuntime,omitempty"`

	// remote socket
	RemoteSocket *RemoteSocket `json:"remoteSocket,omitempty"`

	// security
	Security *SecurityInfo `json:"security,omitempty"`

	// slirp4netns
	Slirp4netns *SlirpInfo `json:"slirp4netns,omitempty"`
}

// Validate validates this host info
func (m *HostInfo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConmon(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDistribution(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateIDMappings(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOciRuntime(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRemoteSocket(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurity(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSlirp4netns(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HostInfo) validateConmon(formats strfmt.Registry) error {
	if swag.IsZero(m.Conmon) { // not required
		return nil
	}

	if m.Conmon != nil {
		if err := m.Conmon.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("conmon")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("conmon")
			}
			return err
		}
	}

	return nil
}

func (m *HostInfo) validateDistribution(formats strfmt.Registry) error {
	if swag.IsZero(m.Distribution) { // not required
		return nil
	}

	if m.Distribution != nil {
		if err := m.Distribution.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("distribution")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("distribution")
			}
			return err
		}
	}

	return nil
}

func (m *HostInfo) validateIDMappings(formats strfmt.Registry) error {
	if swag.IsZero(m.IDMappings) { // not required
		return nil
	}

	if m.IDMappings != nil {
		if err := m.IDMappings.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("idMappings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("idMappings")
			}
			return err
		}
	}

	return nil
}

func (m *HostInfo) validateOciRuntime(formats strfmt.Registry) error {
	if swag.IsZero(m.OciRuntime) { // not required
		return nil
	}

	if m.OciRuntime != nil {
		if err := m.OciRuntime.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ociRuntime")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ociRuntime")
			}
			return err
		}
	}

	return nil
}

func (m *HostInfo) validateRemoteSocket(formats strfmt.Registry) error {
	if swag.IsZero(m.RemoteSocket) { // not required
		return nil
	}

	if m.RemoteSocket != nil {
		if err := m.RemoteSocket.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remoteSocket")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("remoteSocket")
			}
			return err
		}
	}

	return nil
}

func (m *HostInfo) validateSecurity(formats strfmt.Registry) error {
	if swag.IsZero(m.Security) { // not required
		return nil
	}

	if m.Security != nil {
		if err := m.Security.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("security")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("security")
			}
			return err
		}
	}

	return nil
}

func (m *HostInfo) validateSlirp4netns(formats strfmt.Registry) error {
	if swag.IsZero(m.Slirp4netns) { // not required
		return nil
	}

	if m.Slirp4netns != nil {
		if err := m.Slirp4netns.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("slirp4netns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("slirp4netns")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this host info based on the context it is used
func (m *HostInfo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConmon(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDistribution(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateIDMappings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOciRuntime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRemoteSocket(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSecurity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSlirp4netns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HostInfo) contextValidateConmon(ctx context.Context, formats strfmt.Registry) error {

	if m.Conmon != nil {
		if err := m.Conmon.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("conmon")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("conmon")
			}
			return err
		}
	}

	return nil
}

func (m *HostInfo) contextValidateDistribution(ctx context.Context, formats strfmt.Registry) error {

	if m.Distribution != nil {
		if err := m.Distribution.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("distribution")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("distribution")
			}
			return err
		}
	}

	return nil
}

func (m *HostInfo) contextValidateIDMappings(ctx context.Context, formats strfmt.Registry) error {

	if m.IDMappings != nil {
		if err := m.IDMappings.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("idMappings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("idMappings")
			}
			return err
		}
	}

	return nil
}

func (m *HostInfo) contextValidateOciRuntime(ctx context.Context, formats strfmt.Registry) error {

	if m.OciRuntime != nil {
		if err := m.OciRuntime.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("ociRuntime")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("ociRuntime")
			}
			return err
		}
	}

	return nil
}

func (m *HostInfo) contextValidateRemoteSocket(ctx context.Context, formats strfmt.Registry) error {

	if m.RemoteSocket != nil {
		if err := m.RemoteSocket.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("remoteSocket")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("remoteSocket")
			}
			return err
		}
	}

	return nil
}

func (m *HostInfo) contextValidateSecurity(ctx context.Context, formats strfmt.Registry) error {

	if m.Security != nil {
		if err := m.Security.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("security")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("security")
			}
			return err
		}
	}

	return nil
}

func (m *HostInfo) contextValidateSlirp4netns(ctx context.Context, formats strfmt.Registry) error {

	if m.Slirp4netns != nil {
		if err := m.Slirp4netns.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("slirp4netns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("slirp4netns")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HostInfo) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HostInfo) UnmarshalBinary(b []byte) error {
	var res HostInfo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
