// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewContainerInspectLibpodParams creates a new ContainerInspectLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerInspectLibpodParams() *ContainerInspectLibpodParams {
	return &ContainerInspectLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerInspectLibpodParamsWithTimeout creates a new ContainerInspectLibpodParams object
// with the ability to set a timeout on a request.
func NewContainerInspectLibpodParamsWithTimeout(timeout time.Duration) *ContainerInspectLibpodParams {
	return &ContainerInspectLibpodParams{
		timeout: timeout,
	}
}

// NewContainerInspectLibpodParamsWithContext creates a new ContainerInspectLibpodParams object
// with the ability to set a context for a request.
func NewContainerInspectLibpodParamsWithContext(ctx context.Context) *ContainerInspectLibpodParams {
	return &ContainerInspectLibpodParams{
		Context: ctx,
	}
}

// NewContainerInspectLibpodParamsWithHTTPClient creates a new ContainerInspectLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerInspectLibpodParamsWithHTTPClient(client *http.Client) *ContainerInspectLibpodParams {
	return &ContainerInspectLibpodParams{
		HTTPClient: client,
	}
}

/*
ContainerInspectLibpodParams contains all the parameters to send to the API endpoint

	for the container inspect libpod operation.

	Typically these are written to a http.Request.
*/
type ContainerInspectLibpodParams struct {

	/* Name.

	   the name or ID of the container
	*/
	Name string

	/* Size.

	   display filesystem usage
	*/
	Size *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container inspect libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerInspectLibpodParams) WithDefaults() *ContainerInspectLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container inspect libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerInspectLibpodParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the container inspect libpod params
func (o *ContainerInspectLibpodParams) WithTimeout(timeout time.Duration) *ContainerInspectLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container inspect libpod params
func (o *ContainerInspectLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container inspect libpod params
func (o *ContainerInspectLibpodParams) WithContext(ctx context.Context) *ContainerInspectLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container inspect libpod params
func (o *ContainerInspectLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container inspect libpod params
func (o *ContainerInspectLibpodParams) WithHTTPClient(client *http.Client) *ContainerInspectLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container inspect libpod params
func (o *ContainerInspectLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the container inspect libpod params
func (o *ContainerInspectLibpodParams) WithName(name string) *ContainerInspectLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container inspect libpod params
func (o *ContainerInspectLibpodParams) SetName(name string) {
	o.Name = name
}

// WithSize adds the size to the container inspect libpod params
func (o *ContainerInspectLibpodParams) WithSize(size *bool) *ContainerInspectLibpodParams {
	o.SetSize(size)
	return o
}

// SetSize adds the size to the container inspect libpod params
func (o *ContainerInspectLibpodParams) SetSize(size *bool) {
	o.Size = size
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerInspectLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.Size != nil {

		// query param size
		var qrSize bool

		if o.Size != nil {
			qrSize = *o.Size
		}
		qSize := swag.FormatBool(qrSize)
		if qSize != "" {

			if err := r.SetQueryParam("size", qSize); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
