// Code generated by go-swagger; DO NOT EDIT.

package containers

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewContainerStopLibpodParams creates a new ContainerStopLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerStopLibpodParams() *ContainerStopLibpodParams {
	return &ContainerStopLibpodParams{
		requestTimeout: cr.DefaultTimeout,
	}
}

// NewContainerStopLibpodParamsWithTimeout creates a new ContainerStopLibpodParams object
// with the ability to set a timeout on a request.
func NewContainerStopLibpodParamsWithTimeout(timeout time.Duration) *ContainerStopLibpodParams {
	return &ContainerStopLibpodParams{
		requestTimeout: timeout,
	}
}

// NewContainerStopLibpodParamsWithContext creates a new ContainerStopLibpodParams object
// with the ability to set a context for a request.
func NewContainerStopLibpodParamsWithContext(ctx context.Context) *ContainerStopLibpodParams {
	return &ContainerStopLibpodParams{
		Context: ctx,
	}
}

// NewContainerStopLibpodParamsWithHTTPClient creates a new ContainerStopLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerStopLibpodParamsWithHTTPClient(client *http.Client) *ContainerStopLibpodParams {
	return &ContainerStopLibpodParams{
		HTTPClient: client,
	}
}

/*
ContainerStopLibpodParams contains all the parameters to send to the API endpoint

	for the container stop libpod operation.

	Typically these are written to a http.Request.
*/
type ContainerStopLibpodParams struct {

	/* Ignore.

	   do not return error if container is already stopped
	*/
	Ignore *bool

	/* All.

	   Stop all containers
	*/
	All *bool

	/* Name.

	   the name or ID of the container
	*/
	Name string

	/* Timeout.

	   number of seconds to wait before killing container

	   Default: 10
	*/
	Timeout *int64

	requestTimeout time.Duration
	Context        context.Context
	HTTPClient     *http.Client
}

// WithDefaults hydrates default values in the container stop libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerStopLibpodParams) WithDefaults() *ContainerStopLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container stop libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerStopLibpodParams) SetDefaults() {
	var (
		ignoreDefault = bool(false)

		allDefault = bool(false)

		timeoutDefault = int64(10)
	)

	val := ContainerStopLibpodParams{
		Ignore:  &ignoreDefault,
		All:     &allDefault,
		Timeout: &timeoutDefault,
	}

	val.requestTimeout = o.requestTimeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithRequestTimeout adds the timeout to the container stop libpod params
func (o *ContainerStopLibpodParams) WithRequestTimeout(timeout time.Duration) *ContainerStopLibpodParams {
	o.SetRequestTimeout(timeout)
	return o
}

// SetRequestTimeout adds the timeout to the container stop libpod params
func (o *ContainerStopLibpodParams) SetRequestTimeout(timeout time.Duration) {
	o.requestTimeout = timeout
}

// WithContext adds the context to the container stop libpod params
func (o *ContainerStopLibpodParams) WithContext(ctx context.Context) *ContainerStopLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container stop libpod params
func (o *ContainerStopLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container stop libpod params
func (o *ContainerStopLibpodParams) WithHTTPClient(client *http.Client) *ContainerStopLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container stop libpod params
func (o *ContainerStopLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIgnore adds the ignore to the container stop libpod params
func (o *ContainerStopLibpodParams) WithIgnore(ignore *bool) *ContainerStopLibpodParams {
	o.SetIgnore(ignore)
	return o
}

// SetIgnore adds the ignore to the container stop libpod params
func (o *ContainerStopLibpodParams) SetIgnore(ignore *bool) {
	o.Ignore = ignore
}

// WithAll adds the all to the container stop libpod params
func (o *ContainerStopLibpodParams) WithAll(all *bool) *ContainerStopLibpodParams {
	o.SetAll(all)
	return o
}

// SetAll adds the all to the container stop libpod params
func (o *ContainerStopLibpodParams) SetAll(all *bool) {
	o.All = all
}

// WithName adds the name to the container stop libpod params
func (o *ContainerStopLibpodParams) WithName(name string) *ContainerStopLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container stop libpod params
func (o *ContainerStopLibpodParams) SetName(name string) {
	o.Name = name
}

// WithTimeout adds the timeout to the container stop libpod params
func (o *ContainerStopLibpodParams) WithTimeout(timeout *int64) *ContainerStopLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container stop libpod params
func (o *ContainerStopLibpodParams) SetTimeout(timeout *int64) {
	o.Timeout = timeout
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerStopLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.requestTimeout); err != nil {
		return err
	}
	var res []error

	if o.Ignore != nil {

		// query param Ignore
		var qrIgnore bool

		if o.Ignore != nil {
			qrIgnore = *o.Ignore
		}
		qIgnore := swag.FormatBool(qrIgnore)
		if qIgnore != "" {

			if err := r.SetQueryParam("Ignore", qIgnore); err != nil {
				return err
			}
		}
	}

	if o.All != nil {

		// query param all
		var qrAll bool

		if o.All != nil {
			qrAll = *o.All
		}
		qAll := swag.FormatBool(qrAll)
		if qAll != "" {

			if err := r.SetQueryParam("all", qAll); err != nil {
				return err
			}
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.Timeout != nil {

		// query param timeout
		var qrTimeout int64

		if o.Timeout != nil {
			qrTimeout = *o.Timeout
		}
		qTimeout := swag.FormatInt64(qrTimeout)
		if qTimeout != "" {

			if err := r.SetQueryParam("timeout", qTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
