// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewContainerArchiveLibpodParams creates a new ContainerArchiveLibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewContainerArchiveLibpodParams() *ContainerArchiveLibpodParams {
	return &ContainerArchiveLibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewContainerArchiveLibpodParamsWithTimeout creates a new ContainerArchiveLibpodParams object
// with the ability to set a timeout on a request.
func NewContainerArchiveLibpodParamsWithTimeout(timeout time.Duration) *ContainerArchiveLibpodParams {
	return &ContainerArchiveLibpodParams{
		timeout: timeout,
	}
}

// NewContainerArchiveLibpodParamsWithContext creates a new ContainerArchiveLibpodParams object
// with the ability to set a context for a request.
func NewContainerArchiveLibpodParamsWithContext(ctx context.Context) *ContainerArchiveLibpodParams {
	return &ContainerArchiveLibpodParams{
		Context: ctx,
	}
}

// NewContainerArchiveLibpodParamsWithHTTPClient creates a new ContainerArchiveLibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewContainerArchiveLibpodParamsWithHTTPClient(client *http.Client) *ContainerArchiveLibpodParams {
	return &ContainerArchiveLibpodParams{
		HTTPClient: client,
	}
}

/*
ContainerArchiveLibpodParams contains all the parameters to send to the API endpoint

	for the container archive libpod operation.

	Typically these are written to a http.Request.
*/
type ContainerArchiveLibpodParams struct {

	/* Name.

	   container name or id
	*/
	Name string

	/* Path.

	   Path to a directory in the container to extract
	*/
	Path string

	/* Rename.

	   JSON encoded map[string]string to translate paths
	*/
	Rename *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the container archive libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerArchiveLibpodParams) WithDefaults() *ContainerArchiveLibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the container archive libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ContainerArchiveLibpodParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the container archive libpod params
func (o *ContainerArchiveLibpodParams) WithTimeout(timeout time.Duration) *ContainerArchiveLibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the container archive libpod params
func (o *ContainerArchiveLibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the container archive libpod params
func (o *ContainerArchiveLibpodParams) WithContext(ctx context.Context) *ContainerArchiveLibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the container archive libpod params
func (o *ContainerArchiveLibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the container archive libpod params
func (o *ContainerArchiveLibpodParams) WithHTTPClient(client *http.Client) *ContainerArchiveLibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the container archive libpod params
func (o *ContainerArchiveLibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the container archive libpod params
func (o *ContainerArchiveLibpodParams) WithName(name string) *ContainerArchiveLibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the container archive libpod params
func (o *ContainerArchiveLibpodParams) SetName(name string) {
	o.Name = name
}

// WithPath adds the path to the container archive libpod params
func (o *ContainerArchiveLibpodParams) WithPath(path string) *ContainerArchiveLibpodParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the container archive libpod params
func (o *ContainerArchiveLibpodParams) SetPath(path string) {
	o.Path = path
}

// WithRename adds the rename to the container archive libpod params
func (o *ContainerArchiveLibpodParams) WithRename(rename *string) *ContainerArchiveLibpodParams {
	o.SetRename(rename)
	return o
}

// SetRename adds the rename to the container archive libpod params
func (o *ContainerArchiveLibpodParams) SetRename(rename *string) {
	o.Rename = rename
}

// WriteToRequest writes these params to a swagger request
func (o *ContainerArchiveLibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// query param path
	qrPath := o.Path
	qPath := qrPath
	if qPath != "" {

		if err := r.SetQueryParam("path", qPath); err != nil {
			return err
		}
	}

	if o.Rename != nil {

		// query param rename
		var qrRename string

		if o.Rename != nil {
			qrRename = *o.Rename
		}
		qRename := qrRename
		if qRename != "" {

			if err := r.SetQueryParam("rename", qRename); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
