// Code generated by go-swagger; DO NOT EDIT.

package containers_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerArchiveReader is a Reader for the ContainerArchive structure.
type ContainerArchiveReader struct {
	formats strfmt.Registry
	writer  io.Writer
}

// ReadResponse reads a server response into the received o.
func (o *ContainerArchiveReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewContainerArchiveOK(o.writer)
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewContainerArchiveBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewContainerArchiveNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewContainerArchiveInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewContainerArchiveOK creates a ContainerArchiveOK with default headers values
func NewContainerArchiveOK(writer io.Writer) *ContainerArchiveOK {
	return &ContainerArchiveOK{

		Payload: writer,
	}
}

/*
ContainerArchiveOK describes a response with status code 200, with default header values.

no error
*/
type ContainerArchiveOK struct {
	Payload io.Writer
}

// IsSuccess returns true when this container archive o k response has a 2xx status code
func (o *ContainerArchiveOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this container archive o k response has a 3xx status code
func (o *ContainerArchiveOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container archive o k response has a 4xx status code
func (o *ContainerArchiveOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this container archive o k response has a 5xx status code
func (o *ContainerArchiveOK) IsServerError() bool {
	return false
}

// IsCode returns true when this container archive o k response a status code equal to that given
func (o *ContainerArchiveOK) IsCode(code int) bool {
	return code == 200
}

func (o *ContainerArchiveOK) Error() string {
	return fmt.Sprintf("[GET /containers/{name}/archive][%d] containerArchiveOK  %+v", 200, o.Payload)
}

func (o *ContainerArchiveOK) String() string {
	return fmt.Sprintf("[GET /containers/{name}/archive][%d] containerArchiveOK  %+v", 200, o.Payload)
}

func (o *ContainerArchiveOK) GetPayload() io.Writer {
	return o.Payload
}

func (o *ContainerArchiveOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerArchiveBadRequest creates a ContainerArchiveBadRequest with default headers values
func NewContainerArchiveBadRequest() *ContainerArchiveBadRequest {
	return &ContainerArchiveBadRequest{}
}

/*
ContainerArchiveBadRequest describes a response with status code 400, with default header values.

Bad parameter in request
*/
type ContainerArchiveBadRequest struct {
	Payload *ContainerArchiveBadRequestBody
}

// IsSuccess returns true when this container archive bad request response has a 2xx status code
func (o *ContainerArchiveBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container archive bad request response has a 3xx status code
func (o *ContainerArchiveBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container archive bad request response has a 4xx status code
func (o *ContainerArchiveBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this container archive bad request response has a 5xx status code
func (o *ContainerArchiveBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this container archive bad request response a status code equal to that given
func (o *ContainerArchiveBadRequest) IsCode(code int) bool {
	return code == 400
}

func (o *ContainerArchiveBadRequest) Error() string {
	return fmt.Sprintf("[GET /containers/{name}/archive][%d] containerArchiveBadRequest  %+v", 400, o.Payload)
}

func (o *ContainerArchiveBadRequest) String() string {
	return fmt.Sprintf("[GET /containers/{name}/archive][%d] containerArchiveBadRequest  %+v", 400, o.Payload)
}

func (o *ContainerArchiveBadRequest) GetPayload() *ContainerArchiveBadRequestBody {
	return o.Payload
}

func (o *ContainerArchiveBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerArchiveBadRequestBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerArchiveNotFound creates a ContainerArchiveNotFound with default headers values
func NewContainerArchiveNotFound() *ContainerArchiveNotFound {
	return &ContainerArchiveNotFound{}
}

/*
ContainerArchiveNotFound describes a response with status code 404, with default header values.

No such container
*/
type ContainerArchiveNotFound struct {
	Payload *ContainerArchiveNotFoundBody
}

// IsSuccess returns true when this container archive not found response has a 2xx status code
func (o *ContainerArchiveNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container archive not found response has a 3xx status code
func (o *ContainerArchiveNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container archive not found response has a 4xx status code
func (o *ContainerArchiveNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this container archive not found response has a 5xx status code
func (o *ContainerArchiveNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this container archive not found response a status code equal to that given
func (o *ContainerArchiveNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ContainerArchiveNotFound) Error() string {
	return fmt.Sprintf("[GET /containers/{name}/archive][%d] containerArchiveNotFound  %+v", 404, o.Payload)
}

func (o *ContainerArchiveNotFound) String() string {
	return fmt.Sprintf("[GET /containers/{name}/archive][%d] containerArchiveNotFound  %+v", 404, o.Payload)
}

func (o *ContainerArchiveNotFound) GetPayload() *ContainerArchiveNotFoundBody {
	return o.Payload
}

func (o *ContainerArchiveNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerArchiveNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewContainerArchiveInternalServerError creates a ContainerArchiveInternalServerError with default headers values
func NewContainerArchiveInternalServerError() *ContainerArchiveInternalServerError {
	return &ContainerArchiveInternalServerError{}
}

/*
ContainerArchiveInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ContainerArchiveInternalServerError struct {
	Payload *ContainerArchiveInternalServerErrorBody
}

// IsSuccess returns true when this container archive internal server error response has a 2xx status code
func (o *ContainerArchiveInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this container archive internal server error response has a 3xx status code
func (o *ContainerArchiveInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this container archive internal server error response has a 4xx status code
func (o *ContainerArchiveInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this container archive internal server error response has a 5xx status code
func (o *ContainerArchiveInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this container archive internal server error response a status code equal to that given
func (o *ContainerArchiveInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ContainerArchiveInternalServerError) Error() string {
	return fmt.Sprintf("[GET /containers/{name}/archive][%d] containerArchiveInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerArchiveInternalServerError) String() string {
	return fmt.Sprintf("[GET /containers/{name}/archive][%d] containerArchiveInternalServerError  %+v", 500, o.Payload)
}

func (o *ContainerArchiveInternalServerError) GetPayload() *ContainerArchiveInternalServerErrorBody {
	return o.Payload
}

func (o *ContainerArchiveInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ContainerArchiveInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ContainerArchiveBadRequestBody container archive bad request body
swagger:model ContainerArchiveBadRequestBody
*/
type ContainerArchiveBadRequestBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container archive bad request body
func (o *ContainerArchiveBadRequestBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container archive bad request body based on context it is used
func (o *ContainerArchiveBadRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerArchiveBadRequestBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerArchiveBadRequestBody) UnmarshalBinary(b []byte) error {
	var res ContainerArchiveBadRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerArchiveInternalServerErrorBody container archive internal server error body
swagger:model ContainerArchiveInternalServerErrorBody
*/
type ContainerArchiveInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container archive internal server error body
func (o *ContainerArchiveInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container archive internal server error body based on context it is used
func (o *ContainerArchiveInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerArchiveInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerArchiveInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ContainerArchiveInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ContainerArchiveNotFoundBody container archive not found body
swagger:model ContainerArchiveNotFoundBody
*/
type ContainerArchiveNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this container archive not found body
func (o *ContainerArchiveNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this container archive not found body based on context it is used
func (o *ContainerArchiveNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ContainerArchiveNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ContainerArchiveNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ContainerArchiveNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
