// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ImageGetLibpodReader is a Reader for the ImageGetLibpod structure.
type ImageGetLibpodReader struct {
	formats strfmt.Registry
	writer  io.Writer
}

// ReadResponse reads a server response into the received o.
func (o *ImageGetLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewImageGetLibpodOK(o.writer)
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewImageGetLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewImageGetLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewImageGetLibpodOK creates a ImageGetLibpodOK with default headers values
func NewImageGetLibpodOK(writer io.Writer) *ImageGetLibpodOK {
	return &ImageGetLibpodOK{

		Payload: writer,
	}
}

/*
ImageGetLibpodOK describes a response with status code 200, with default header values.

no error
*/
type ImageGetLibpodOK struct {
	Payload io.Writer
}

// IsSuccess returns true when this image get libpod o k response has a 2xx status code
func (o *ImageGetLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this image get libpod o k response has a 3xx status code
func (o *ImageGetLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image get libpod o k response has a 4xx status code
func (o *ImageGetLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this image get libpod o k response has a 5xx status code
func (o *ImageGetLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this image get libpod o k response a status code equal to that given
func (o *ImageGetLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ImageGetLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/get][%d] imageGetLibpodOK  %+v", 200, o.Payload)
}

func (o *ImageGetLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/get][%d] imageGetLibpodOK  %+v", 200, o.Payload)
}

func (o *ImageGetLibpodOK) GetPayload() io.Writer {
	return o.Payload
}

func (o *ImageGetLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageGetLibpodNotFound creates a ImageGetLibpodNotFound with default headers values
func NewImageGetLibpodNotFound() *ImageGetLibpodNotFound {
	return &ImageGetLibpodNotFound{}
}

/*
ImageGetLibpodNotFound describes a response with status code 404, with default header values.

No such image
*/
type ImageGetLibpodNotFound struct {
	Payload *ImageGetLibpodNotFoundBody
}

// IsSuccess returns true when this image get libpod not found response has a 2xx status code
func (o *ImageGetLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image get libpod not found response has a 3xx status code
func (o *ImageGetLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image get libpod not found response has a 4xx status code
func (o *ImageGetLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this image get libpod not found response has a 5xx status code
func (o *ImageGetLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this image get libpod not found response a status code equal to that given
func (o *ImageGetLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ImageGetLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/get][%d] imageGetLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ImageGetLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/get][%d] imageGetLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ImageGetLibpodNotFound) GetPayload() *ImageGetLibpodNotFoundBody {
	return o.Payload
}

func (o *ImageGetLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageGetLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageGetLibpodInternalServerError creates a ImageGetLibpodInternalServerError with default headers values
func NewImageGetLibpodInternalServerError() *ImageGetLibpodInternalServerError {
	return &ImageGetLibpodInternalServerError{}
}

/*
ImageGetLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ImageGetLibpodInternalServerError struct {
	Payload *ImageGetLibpodInternalServerErrorBody
}

// IsSuccess returns true when this image get libpod internal server error response has a 2xx status code
func (o *ImageGetLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image get libpod internal server error response has a 3xx status code
func (o *ImageGetLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image get libpod internal server error response has a 4xx status code
func (o *ImageGetLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this image get libpod internal server error response has a 5xx status code
func (o *ImageGetLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this image get libpod internal server error response a status code equal to that given
func (o *ImageGetLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ImageGetLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/get][%d] imageGetLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageGetLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/images/{name}/get][%d] imageGetLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageGetLibpodInternalServerError) GetPayload() *ImageGetLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ImageGetLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageGetLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ImageGetLibpodInternalServerErrorBody image get libpod internal server error body
swagger:model ImageGetLibpodInternalServerErrorBody
*/
type ImageGetLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image get libpod internal server error body
func (o *ImageGetLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image get libpod internal server error body based on context it is used
func (o *ImageGetLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageGetLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageGetLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ImageGetLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageGetLibpodNotFoundBody image get libpod not found body
swagger:model ImageGetLibpodNotFoundBody
*/
type ImageGetLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image get libpod not found body
func (o *ImageGetLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image get libpod not found body based on context it is used
func (o *ImageGetLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageGetLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageGetLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ImageGetLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
