// Code generated by go-swagger; DO NOT EDIT.

package images

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ImageSearchLibpodReader is a Reader for the ImageSearchLibpod structure.
type ImageSearchLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ImageSearchLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewImageSearchLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewImageSearchLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewImageSearchLibpodOK creates a ImageSearchLibpodOK with default headers values
func NewImageSearchLibpodOK() *ImageSearchLibpodOK {
	return &ImageSearchLibpodOK{}
}

/*
ImageSearchLibpodOK describes a response with status code 200, with default header values.

Search results
*/
type ImageSearchLibpodOK struct {
	Payload *ImageSearchLibpodOKBody
}

// IsSuccess returns true when this image search libpod o k response has a 2xx status code
func (o *ImageSearchLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this image search libpod o k response has a 3xx status code
func (o *ImageSearchLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image search libpod o k response has a 4xx status code
func (o *ImageSearchLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this image search libpod o k response has a 5xx status code
func (o *ImageSearchLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this image search libpod o k response a status code equal to that given
func (o *ImageSearchLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ImageSearchLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/images/search][%d] imageSearchLibpodOK  %+v", 200, o.Payload)
}

func (o *ImageSearchLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/images/search][%d] imageSearchLibpodOK  %+v", 200, o.Payload)
}

func (o *ImageSearchLibpodOK) GetPayload() *ImageSearchLibpodOKBody {
	return o.Payload
}

func (o *ImageSearchLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageSearchLibpodOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewImageSearchLibpodInternalServerError creates a ImageSearchLibpodInternalServerError with default headers values
func NewImageSearchLibpodInternalServerError() *ImageSearchLibpodInternalServerError {
	return &ImageSearchLibpodInternalServerError{}
}

/*
ImageSearchLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ImageSearchLibpodInternalServerError struct {
	Payload *ImageSearchLibpodInternalServerErrorBody
}

// IsSuccess returns true when this image search libpod internal server error response has a 2xx status code
func (o *ImageSearchLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this image search libpod internal server error response has a 3xx status code
func (o *ImageSearchLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this image search libpod internal server error response has a 4xx status code
func (o *ImageSearchLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this image search libpod internal server error response has a 5xx status code
func (o *ImageSearchLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this image search libpod internal server error response a status code equal to that given
func (o *ImageSearchLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ImageSearchLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/images/search][%d] imageSearchLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageSearchLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/images/search][%d] imageSearchLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ImageSearchLibpodInternalServerError) GetPayload() *ImageSearchLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ImageSearchLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ImageSearchLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ImageSearchLibpodInternalServerErrorBody image search libpod internal server error body
swagger:model ImageSearchLibpodInternalServerErrorBody
*/
type ImageSearchLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this image search libpod internal server error body
func (o *ImageSearchLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image search libpod internal server error body based on context it is used
func (o *ImageSearchLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageSearchLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageSearchLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ImageSearchLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ImageSearchLibpodOKBody image search libpod o k body
swagger:model ImageSearchLibpodOKBody
*/
type ImageSearchLibpodOKBody struct {

	// Automated indicates if the image was created by an automated build.
	Automated string `json:"Automated,omitempty"`

	// Description of the image.
	Description string `json:"Description,omitempty"`

	// Index is the image index (e.g., "docker.io" or "quay.io")
	Index string `json:"Index,omitempty"`

	// Name is the canonical name of the image (e.g., "docker.io/library/alpine").
	Name string `json:"Name,omitempty"`

	// Official indicates if it's an official image.
	Official string `json:"Official,omitempty"`

	// Stars is the number of stars of the image.
	Stars int64 `json:"Stars,omitempty"`

	// Tag is the image tag
	Tag string `json:"Tag,omitempty"`
}

// Validate validates this image search libpod o k body
func (o *ImageSearchLibpodOKBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this image search libpod o k body based on context it is used
func (o *ImageSearchLibpodOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ImageSearchLibpodOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ImageSearchLibpodOKBody) UnmarshalBinary(b []byte) error {
	var res ImageSearchLibpodOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
