// Code generated by go-swagger; DO NOT EDIT.

package manifests

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// ManifestAddLibpodReader is a Reader for the ManifestAddLibpod structure.
type ManifestAddLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ManifestAddLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewManifestAddLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewManifestAddLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewManifestAddLibpodConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewManifestAddLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewManifestAddLibpodOK creates a ManifestAddLibpodOK with default headers values
func NewManifestAddLibpodOK() *ManifestAddLibpodOK {
	return &ManifestAddLibpodOK{}
}

/*
ManifestAddLibpodOK describes a response with status code 200, with default header values.

ManifestAddLibpodOK manifest add libpod o k
*/
type ManifestAddLibpodOK struct {
	Payload *models.IDResponse
}

// IsSuccess returns true when this manifest add libpod o k response has a 2xx status code
func (o *ManifestAddLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this manifest add libpod o k response has a 3xx status code
func (o *ManifestAddLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this manifest add libpod o k response has a 4xx status code
func (o *ManifestAddLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this manifest add libpod o k response has a 5xx status code
func (o *ManifestAddLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this manifest add libpod o k response a status code equal to that given
func (o *ManifestAddLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *ManifestAddLibpodOK) Error() string {
	return fmt.Sprintf("[POST /libpod/manifests/{name}/add][%d] manifestAddLibpodOK  %+v", 200, o.Payload)
}

func (o *ManifestAddLibpodOK) String() string {
	return fmt.Sprintf("[POST /libpod/manifests/{name}/add][%d] manifestAddLibpodOK  %+v", 200, o.Payload)
}

func (o *ManifestAddLibpodOK) GetPayload() *models.IDResponse {
	return o.Payload
}

func (o *ManifestAddLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.IDResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewManifestAddLibpodNotFound creates a ManifestAddLibpodNotFound with default headers values
func NewManifestAddLibpodNotFound() *ManifestAddLibpodNotFound {
	return &ManifestAddLibpodNotFound{}
}

/*
ManifestAddLibpodNotFound describes a response with status code 404, with default header values.

No such manifest
*/
type ManifestAddLibpodNotFound struct {
	Payload *ManifestAddLibpodNotFoundBody
}

// IsSuccess returns true when this manifest add libpod not found response has a 2xx status code
func (o *ManifestAddLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this manifest add libpod not found response has a 3xx status code
func (o *ManifestAddLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this manifest add libpod not found response has a 4xx status code
func (o *ManifestAddLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this manifest add libpod not found response has a 5xx status code
func (o *ManifestAddLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this manifest add libpod not found response a status code equal to that given
func (o *ManifestAddLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ManifestAddLibpodNotFound) Error() string {
	return fmt.Sprintf("[POST /libpod/manifests/{name}/add][%d] manifestAddLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ManifestAddLibpodNotFound) String() string {
	return fmt.Sprintf("[POST /libpod/manifests/{name}/add][%d] manifestAddLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ManifestAddLibpodNotFound) GetPayload() *ManifestAddLibpodNotFoundBody {
	return o.Payload
}

func (o *ManifestAddLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ManifestAddLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewManifestAddLibpodConflict creates a ManifestAddLibpodConflict with default headers values
func NewManifestAddLibpodConflict() *ManifestAddLibpodConflict {
	return &ManifestAddLibpodConflict{}
}

/*
ManifestAddLibpodConflict describes a response with status code 409, with default header values.

Bad parameter in request
*/
type ManifestAddLibpodConflict struct {
	Payload *ManifestAddLibpodConflictBody
}

// IsSuccess returns true when this manifest add libpod conflict response has a 2xx status code
func (o *ManifestAddLibpodConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this manifest add libpod conflict response has a 3xx status code
func (o *ManifestAddLibpodConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this manifest add libpod conflict response has a 4xx status code
func (o *ManifestAddLibpodConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this manifest add libpod conflict response has a 5xx status code
func (o *ManifestAddLibpodConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this manifest add libpod conflict response a status code equal to that given
func (o *ManifestAddLibpodConflict) IsCode(code int) bool {
	return code == 409
}

func (o *ManifestAddLibpodConflict) Error() string {
	return fmt.Sprintf("[POST /libpod/manifests/{name}/add][%d] manifestAddLibpodConflict  %+v", 409, o.Payload)
}

func (o *ManifestAddLibpodConflict) String() string {
	return fmt.Sprintf("[POST /libpod/manifests/{name}/add][%d] manifestAddLibpodConflict  %+v", 409, o.Payload)
}

func (o *ManifestAddLibpodConflict) GetPayload() *ManifestAddLibpodConflictBody {
	return o.Payload
}

func (o *ManifestAddLibpodConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ManifestAddLibpodConflictBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewManifestAddLibpodInternalServerError creates a ManifestAddLibpodInternalServerError with default headers values
func NewManifestAddLibpodInternalServerError() *ManifestAddLibpodInternalServerError {
	return &ManifestAddLibpodInternalServerError{}
}

/*
ManifestAddLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ManifestAddLibpodInternalServerError struct {
	Payload *ManifestAddLibpodInternalServerErrorBody
}

// IsSuccess returns true when this manifest add libpod internal server error response has a 2xx status code
func (o *ManifestAddLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this manifest add libpod internal server error response has a 3xx status code
func (o *ManifestAddLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this manifest add libpod internal server error response has a 4xx status code
func (o *ManifestAddLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this manifest add libpod internal server error response has a 5xx status code
func (o *ManifestAddLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this manifest add libpod internal server error response a status code equal to that given
func (o *ManifestAddLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ManifestAddLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[POST /libpod/manifests/{name}/add][%d] manifestAddLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ManifestAddLibpodInternalServerError) String() string {
	return fmt.Sprintf("[POST /libpod/manifests/{name}/add][%d] manifestAddLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ManifestAddLibpodInternalServerError) GetPayload() *ManifestAddLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ManifestAddLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ManifestAddLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ManifestAddLibpodConflictBody manifest add libpod conflict body
swagger:model ManifestAddLibpodConflictBody
*/
type ManifestAddLibpodConflictBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this manifest add libpod conflict body
func (o *ManifestAddLibpodConflictBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this manifest add libpod conflict body based on context it is used
func (o *ManifestAddLibpodConflictBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ManifestAddLibpodConflictBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ManifestAddLibpodConflictBody) UnmarshalBinary(b []byte) error {
	var res ManifestAddLibpodConflictBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ManifestAddLibpodInternalServerErrorBody manifest add libpod internal server error body
swagger:model ManifestAddLibpodInternalServerErrorBody
*/
type ManifestAddLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this manifest add libpod internal server error body
func (o *ManifestAddLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this manifest add libpod internal server error body based on context it is used
func (o *ManifestAddLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ManifestAddLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ManifestAddLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ManifestAddLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ManifestAddLibpodNotFoundBody manifest add libpod not found body
swagger:model ManifestAddLibpodNotFoundBody
*/
type ManifestAddLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this manifest add libpod not found body
func (o *ManifestAddLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this manifest add libpod not found body based on context it is used
func (o *ManifestAddLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ManifestAddLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ManifestAddLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ManifestAddLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
