// Code generated by go-swagger; DO NOT EDIT.

package manifests

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ManifestExistsLibpodReader is a Reader for the ManifestExistsLibpod structure.
type ManifestExistsLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ManifestExistsLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewManifestExistsLibpodNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewManifestExistsLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewManifestExistsLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewManifestExistsLibpodNoContent creates a ManifestExistsLibpodNoContent with default headers values
func NewManifestExistsLibpodNoContent() *ManifestExistsLibpodNoContent {
	return &ManifestExistsLibpodNoContent{}
}

/*
ManifestExistsLibpodNoContent describes a response with status code 204, with default header values.

manifest list exists
*/
type ManifestExistsLibpodNoContent struct {
}

// IsSuccess returns true when this manifest exists libpod no content response has a 2xx status code
func (o *ManifestExistsLibpodNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this manifest exists libpod no content response has a 3xx status code
func (o *ManifestExistsLibpodNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this manifest exists libpod no content response has a 4xx status code
func (o *ManifestExistsLibpodNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this manifest exists libpod no content response has a 5xx status code
func (o *ManifestExistsLibpodNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this manifest exists libpod no content response a status code equal to that given
func (o *ManifestExistsLibpodNoContent) IsCode(code int) bool {
	return code == 204
}

func (o *ManifestExistsLibpodNoContent) Error() string {
	return fmt.Sprintf("[GET /libpod/manifests/{name}/exists][%d] manifestExistsLibpodNoContent ", 204)
}

func (o *ManifestExistsLibpodNoContent) String() string {
	return fmt.Sprintf("[GET /libpod/manifests/{name}/exists][%d] manifestExistsLibpodNoContent ", 204)
}

func (o *ManifestExistsLibpodNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewManifestExistsLibpodNotFound creates a ManifestExistsLibpodNotFound with default headers values
func NewManifestExistsLibpodNotFound() *ManifestExistsLibpodNotFound {
	return &ManifestExistsLibpodNotFound{}
}

/*
ManifestExistsLibpodNotFound describes a response with status code 404, with default header values.

No such manifest
*/
type ManifestExistsLibpodNotFound struct {
	Payload *ManifestExistsLibpodNotFoundBody
}

// IsSuccess returns true when this manifest exists libpod not found response has a 2xx status code
func (o *ManifestExistsLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this manifest exists libpod not found response has a 3xx status code
func (o *ManifestExistsLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this manifest exists libpod not found response has a 4xx status code
func (o *ManifestExistsLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this manifest exists libpod not found response has a 5xx status code
func (o *ManifestExistsLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this manifest exists libpod not found response a status code equal to that given
func (o *ManifestExistsLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *ManifestExistsLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/manifests/{name}/exists][%d] manifestExistsLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ManifestExistsLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/manifests/{name}/exists][%d] manifestExistsLibpodNotFound  %+v", 404, o.Payload)
}

func (o *ManifestExistsLibpodNotFound) GetPayload() *ManifestExistsLibpodNotFoundBody {
	return o.Payload
}

func (o *ManifestExistsLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ManifestExistsLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewManifestExistsLibpodInternalServerError creates a ManifestExistsLibpodInternalServerError with default headers values
func NewManifestExistsLibpodInternalServerError() *ManifestExistsLibpodInternalServerError {
	return &ManifestExistsLibpodInternalServerError{}
}

/*
ManifestExistsLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type ManifestExistsLibpodInternalServerError struct {
	Payload *ManifestExistsLibpodInternalServerErrorBody
}

// IsSuccess returns true when this manifest exists libpod internal server error response has a 2xx status code
func (o *ManifestExistsLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this manifest exists libpod internal server error response has a 3xx status code
func (o *ManifestExistsLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this manifest exists libpod internal server error response has a 4xx status code
func (o *ManifestExistsLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this manifest exists libpod internal server error response has a 5xx status code
func (o *ManifestExistsLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this manifest exists libpod internal server error response a status code equal to that given
func (o *ManifestExistsLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *ManifestExistsLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/manifests/{name}/exists][%d] manifestExistsLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ManifestExistsLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/manifests/{name}/exists][%d] manifestExistsLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *ManifestExistsLibpodInternalServerError) GetPayload() *ManifestExistsLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *ManifestExistsLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(ManifestExistsLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ManifestExistsLibpodInternalServerErrorBody manifest exists libpod internal server error body
swagger:model ManifestExistsLibpodInternalServerErrorBody
*/
type ManifestExistsLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this manifest exists libpod internal server error body
func (o *ManifestExistsLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this manifest exists libpod internal server error body based on context it is used
func (o *ManifestExistsLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ManifestExistsLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ManifestExistsLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res ManifestExistsLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ManifestExistsLibpodNotFoundBody manifest exists libpod not found body
swagger:model ManifestExistsLibpodNotFoundBody
*/
type ManifestExistsLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this manifest exists libpod not found body
func (o *ManifestExistsLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this manifest exists libpod not found body based on context it is used
func (o *ManifestExistsLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ManifestExistsLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ManifestExistsLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res ManifestExistsLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
