// Code generated by go-swagger; DO NOT EDIT.

package manifests

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewManifestPushV3LibpodParams creates a new ManifestPushV3LibpodParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewManifestPushV3LibpodParams() *ManifestPushV3LibpodParams {
	return &ManifestPushV3LibpodParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewManifestPushV3LibpodParamsWithTimeout creates a new ManifestPushV3LibpodParams object
// with the ability to set a timeout on a request.
func NewManifestPushV3LibpodParamsWithTimeout(timeout time.Duration) *ManifestPushV3LibpodParams {
	return &ManifestPushV3LibpodParams{
		timeout: timeout,
	}
}

// NewManifestPushV3LibpodParamsWithContext creates a new ManifestPushV3LibpodParams object
// with the ability to set a context for a request.
func NewManifestPushV3LibpodParamsWithContext(ctx context.Context) *ManifestPushV3LibpodParams {
	return &ManifestPushV3LibpodParams{
		Context: ctx,
	}
}

// NewManifestPushV3LibpodParamsWithHTTPClient creates a new ManifestPushV3LibpodParams object
// with the ability to set a custom HTTPClient for a request.
func NewManifestPushV3LibpodParamsWithHTTPClient(client *http.Client) *ManifestPushV3LibpodParams {
	return &ManifestPushV3LibpodParams{
		HTTPClient: client,
	}
}

/*
ManifestPushV3LibpodParams contains all the parameters to send to the API endpoint

	for the manifest push v3 libpod operation.

	Typically these are written to a http.Request.
*/
type ManifestPushV3LibpodParams struct {

	/* All.

	   push all images
	*/
	All *bool

	/* Destination.

	   the destination for the manifest
	*/
	Destination string

	/* Name.

	   the name or ID of the manifest
	*/
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the manifest push v3 libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ManifestPushV3LibpodParams) WithDefaults() *ManifestPushV3LibpodParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the manifest push v3 libpod params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ManifestPushV3LibpodParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the manifest push v3 libpod params
func (o *ManifestPushV3LibpodParams) WithTimeout(timeout time.Duration) *ManifestPushV3LibpodParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the manifest push v3 libpod params
func (o *ManifestPushV3LibpodParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the manifest push v3 libpod params
func (o *ManifestPushV3LibpodParams) WithContext(ctx context.Context) *ManifestPushV3LibpodParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the manifest push v3 libpod params
func (o *ManifestPushV3LibpodParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the manifest push v3 libpod params
func (o *ManifestPushV3LibpodParams) WithHTTPClient(client *http.Client) *ManifestPushV3LibpodParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the manifest push v3 libpod params
func (o *ManifestPushV3LibpodParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAll adds the all to the manifest push v3 libpod params
func (o *ManifestPushV3LibpodParams) WithAll(all *bool) *ManifestPushV3LibpodParams {
	o.SetAll(all)
	return o
}

// SetAll adds the all to the manifest push v3 libpod params
func (o *ManifestPushV3LibpodParams) SetAll(all *bool) {
	o.All = all
}

// WithDestination adds the destination to the manifest push v3 libpod params
func (o *ManifestPushV3LibpodParams) WithDestination(destination string) *ManifestPushV3LibpodParams {
	o.SetDestination(destination)
	return o
}

// SetDestination adds the destination to the manifest push v3 libpod params
func (o *ManifestPushV3LibpodParams) SetDestination(destination string) {
	o.Destination = destination
}

// WithName adds the name to the manifest push v3 libpod params
func (o *ManifestPushV3LibpodParams) WithName(name string) *ManifestPushV3LibpodParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the manifest push v3 libpod params
func (o *ManifestPushV3LibpodParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *ManifestPushV3LibpodParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.All != nil {

		// query param all
		var qrAll bool

		if o.All != nil {
			qrAll = *o.All
		}
		qAll := swag.FormatBool(qrAll)
		if qAll != "" {

			if err := r.SetQueryParam("all", qAll); err != nil {
				return err
			}
		}
	}

	// query param destination
	qrDestination := o.Destination
	qDestination := qrDestination
	if qDestination != "" {

		if err := r.SetQueryParam("destination", qDestination); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
