// Code generated by go-swagger; DO NOT EDIT.

package networks

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// NetworkInspectLibpodReader is a Reader for the NetworkInspectLibpod structure.
type NetworkInspectLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkInspectLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkInspectLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewNetworkInspectLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewNetworkInspectLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewNetworkInspectLibpodOK creates a NetworkInspectLibpodOK with default headers values
func NewNetworkInspectLibpodOK() *NetworkInspectLibpodOK {
	return &NetworkInspectLibpodOK{}
}

/*
NetworkInspectLibpodOK describes a response with status code 200, with default header values.

Network inspect
*/
type NetworkInspectLibpodOK struct {
	Payload *models.Network
}

// IsSuccess returns true when this network inspect libpod o k response has a 2xx status code
func (o *NetworkInspectLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network inspect libpod o k response has a 3xx status code
func (o *NetworkInspectLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network inspect libpod o k response has a 4xx status code
func (o *NetworkInspectLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network inspect libpod o k response has a 5xx status code
func (o *NetworkInspectLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network inspect libpod o k response a status code equal to that given
func (o *NetworkInspectLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *NetworkInspectLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/networks/{name}/json][%d] networkInspectLibpodOK  %+v", 200, o.Payload)
}

func (o *NetworkInspectLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/networks/{name}/json][%d] networkInspectLibpodOK  %+v", 200, o.Payload)
}

func (o *NetworkInspectLibpodOK) GetPayload() *models.Network {
	return o.Payload
}

func (o *NetworkInspectLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Network)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNetworkInspectLibpodNotFound creates a NetworkInspectLibpodNotFound with default headers values
func NewNetworkInspectLibpodNotFound() *NetworkInspectLibpodNotFound {
	return &NetworkInspectLibpodNotFound{}
}

/*
NetworkInspectLibpodNotFound describes a response with status code 404, with default header values.

No such network
*/
type NetworkInspectLibpodNotFound struct {
	Payload *NetworkInspectLibpodNotFoundBody
}

// IsSuccess returns true when this network inspect libpod not found response has a 2xx status code
func (o *NetworkInspectLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this network inspect libpod not found response has a 3xx status code
func (o *NetworkInspectLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network inspect libpod not found response has a 4xx status code
func (o *NetworkInspectLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this network inspect libpod not found response has a 5xx status code
func (o *NetworkInspectLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this network inspect libpod not found response a status code equal to that given
func (o *NetworkInspectLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *NetworkInspectLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/networks/{name}/json][%d] networkInspectLibpodNotFound  %+v", 404, o.Payload)
}

func (o *NetworkInspectLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/networks/{name}/json][%d] networkInspectLibpodNotFound  %+v", 404, o.Payload)
}

func (o *NetworkInspectLibpodNotFound) GetPayload() *NetworkInspectLibpodNotFoundBody {
	return o.Payload
}

func (o *NetworkInspectLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(NetworkInspectLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNetworkInspectLibpodInternalServerError creates a NetworkInspectLibpodInternalServerError with default headers values
func NewNetworkInspectLibpodInternalServerError() *NetworkInspectLibpodInternalServerError {
	return &NetworkInspectLibpodInternalServerError{}
}

/*
NetworkInspectLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type NetworkInspectLibpodInternalServerError struct {
	Payload *NetworkInspectLibpodInternalServerErrorBody
}

// IsSuccess returns true when this network inspect libpod internal server error response has a 2xx status code
func (o *NetworkInspectLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this network inspect libpod internal server error response has a 3xx status code
func (o *NetworkInspectLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network inspect libpod internal server error response has a 4xx status code
func (o *NetworkInspectLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this network inspect libpod internal server error response has a 5xx status code
func (o *NetworkInspectLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this network inspect libpod internal server error response a status code equal to that given
func (o *NetworkInspectLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *NetworkInspectLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/networks/{name}/json][%d] networkInspectLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *NetworkInspectLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/networks/{name}/json][%d] networkInspectLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *NetworkInspectLibpodInternalServerError) GetPayload() *NetworkInspectLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *NetworkInspectLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(NetworkInspectLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NetworkInspectLibpodInternalServerErrorBody network inspect libpod internal server error body
swagger:model NetworkInspectLibpodInternalServerErrorBody
*/
type NetworkInspectLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this network inspect libpod internal server error body
func (o *NetworkInspectLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this network inspect libpod internal server error body based on context it is used
func (o *NetworkInspectLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NetworkInspectLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkInspectLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res NetworkInspectLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
NetworkInspectLibpodNotFoundBody network inspect libpod not found body
swagger:model NetworkInspectLibpodNotFoundBody
*/
type NetworkInspectLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this network inspect libpod not found body
func (o *NetworkInspectLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this network inspect libpod not found body based on context it is used
func (o *NetworkInspectLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *NetworkInspectLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkInspectLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res NetworkInspectLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
