// Code generated by go-swagger; DO NOT EDIT.

package pods

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// PodInspectLibpodReader is a Reader for the PodInspectLibpod structure.
type PodInspectLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PodInspectLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPodInspectLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewPodInspectLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPodInspectLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewPodInspectLibpodOK creates a PodInspectLibpodOK with default headers values
func NewPodInspectLibpodOK() *PodInspectLibpodOK {
	return &PodInspectLibpodOK{}
}

/*
PodInspectLibpodOK describes a response with status code 200, with default header values.

Inspect pod
*/
type PodInspectLibpodOK struct {
	Payload *PodInspectLibpodOKBody
}

// IsSuccess returns true when this pod inspect libpod o k response has a 2xx status code
func (o *PodInspectLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this pod inspect libpod o k response has a 3xx status code
func (o *PodInspectLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod inspect libpod o k response has a 4xx status code
func (o *PodInspectLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod inspect libpod o k response has a 5xx status code
func (o *PodInspectLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this pod inspect libpod o k response a status code equal to that given
func (o *PodInspectLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *PodInspectLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/json][%d] podInspectLibpodOK  %+v", 200, o.Payload)
}

func (o *PodInspectLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/json][%d] podInspectLibpodOK  %+v", 200, o.Payload)
}

func (o *PodInspectLibpodOK) GetPayload() *PodInspectLibpodOKBody {
	return o.Payload
}

func (o *PodInspectLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodInspectLibpodOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodInspectLibpodNotFound creates a PodInspectLibpodNotFound with default headers values
func NewPodInspectLibpodNotFound() *PodInspectLibpodNotFound {
	return &PodInspectLibpodNotFound{}
}

/*
PodInspectLibpodNotFound describes a response with status code 404, with default header values.

No such pod
*/
type PodInspectLibpodNotFound struct {
	Payload *PodInspectLibpodNotFoundBody
}

// IsSuccess returns true when this pod inspect libpod not found response has a 2xx status code
func (o *PodInspectLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod inspect libpod not found response has a 3xx status code
func (o *PodInspectLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod inspect libpod not found response has a 4xx status code
func (o *PodInspectLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this pod inspect libpod not found response has a 5xx status code
func (o *PodInspectLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this pod inspect libpod not found response a status code equal to that given
func (o *PodInspectLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *PodInspectLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/json][%d] podInspectLibpodNotFound  %+v", 404, o.Payload)
}

func (o *PodInspectLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/json][%d] podInspectLibpodNotFound  %+v", 404, o.Payload)
}

func (o *PodInspectLibpodNotFound) GetPayload() *PodInspectLibpodNotFoundBody {
	return o.Payload
}

func (o *PodInspectLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodInspectLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodInspectLibpodInternalServerError creates a PodInspectLibpodInternalServerError with default headers values
func NewPodInspectLibpodInternalServerError() *PodInspectLibpodInternalServerError {
	return &PodInspectLibpodInternalServerError{}
}

/*
PodInspectLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type PodInspectLibpodInternalServerError struct {
	Payload *PodInspectLibpodInternalServerErrorBody
}

// IsSuccess returns true when this pod inspect libpod internal server error response has a 2xx status code
func (o *PodInspectLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod inspect libpod internal server error response has a 3xx status code
func (o *PodInspectLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod inspect libpod internal server error response has a 4xx status code
func (o *PodInspectLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod inspect libpod internal server error response has a 5xx status code
func (o *PodInspectLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this pod inspect libpod internal server error response a status code equal to that given
func (o *PodInspectLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *PodInspectLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/json][%d] podInspectLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PodInspectLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/json][%d] podInspectLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PodInspectLibpodInternalServerError) GetPayload() *PodInspectLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *PodInspectLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodInspectLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
PodInspectLibpodInternalServerErrorBody pod inspect libpod internal server error body
swagger:model PodInspectLibpodInternalServerErrorBody
*/
type PodInspectLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod inspect libpod internal server error body
func (o *PodInspectLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod inspect libpod internal server error body based on context it is used
func (o *PodInspectLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodInspectLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodInspectLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res PodInspectLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PodInspectLibpodNotFoundBody pod inspect libpod not found body
swagger:model PodInspectLibpodNotFoundBody
*/
type PodInspectLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod inspect libpod not found body
func (o *PodInspectLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod inspect libpod not found body based on context it is used
func (o *PodInspectLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodInspectLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodInspectLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res PodInspectLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PodInspectLibpodOKBody pod inspect libpod o k body
swagger:model PodInspectLibpodOKBody
*/
type PodInspectLibpodOKBody struct {

	// BlkioDeviceReadBps contains the Read/Access limit for the pod's devices
	BlkioDeviceReadBps []*models.InspectBlkioThrottleDevice `json:"device_read_bps"`

	// CPUPeriod contains the CPU period of the pod
	CPUPeriod uint64 `json:"cpu_period,omitempty"`

	// CPUQuota contains the CPU quota of the pod
	CPUQuota int64 `json:"cpu_quota,omitempty"`

	// CPUSetCPUs contains linux specific CPU data for the pod
	CPUSetCPUs string `json:"cpuset_cpus,omitempty"`

	// CgroupParent is the parent of the pod's Cgroup.
	CgroupParent string `json:"CgroupParent,omitempty"`

	// CgroupPath is the path to the pod's Cgroup.
	CgroupPath string `json:"CgroupPath,omitempty"`

	// Containers gives a brief summary of all containers in the pod and
	// their current status.
	Containers []*models.InspectPodContainerInfo `json:"Containers"`

	// CreateCgroup is whether this pod will create its own Cgroup to group
	// containers under.
	CreateCgroup bool `json:"CreateCgroup,omitempty"`

	// CreateCommand is the full command plus arguments of the process the
	// container has been created with.
	CreateCommand []string `json:"CreateCommand"`

	// CreateInfra is whether this pod will create an infra container to
	// share namespaces.
	CreateInfra bool `json:"CreateInfra,omitempty"`

	// Created is the time when the pod was created.
	// Format: date-time
	Created strfmt.DateTime `json:"Created,omitempty"`

	// Devices contains the specified host devices
	Devices []*models.InspectDevice `json:"devices"`

	// Hostname is the hostname that the pod will set.
	Hostname string `json:"Hostname,omitempty"`

	// ID is the ID of the pod.
	ID string `json:"Id,omitempty"`

	// infra config
	InfraConfig *models.InspectPodInfraConfig `json:"InfraConfig,omitempty"`

	// InfraContainerID is the ID of the pod's infra container, if one is
	// present.
	InfraContainerID string `json:"InfraContainerID,omitempty"`

	// Labels is a set of key-value labels that have been applied to the
	// pod.
	Labels map[string]string `json:"Labels,omitempty"`

	// Mounts contains volume related information for the pod
	Mounts []*models.InspectMount `json:"mounts"`

	// Name is the name of the pod.
	Name string `json:"Name,omitempty"`

	// Namespace is the Libpod namespace the pod is placed in.
	Namespace string `json:"Namespace,omitempty"`

	// NumContainers is the number of containers in the pod, including the
	// infra container.
	NumContainers uint64 `json:"NumContainers,omitempty"`

	// SecurityOpt contains the specified security labels and related SELinux information
	SecurityOpts []string `json:"security_opt"`

	// SharedNamespaces contains a list of namespaces that will be shared by
	// containers within the pod. Can only be set if CreateInfra is true.
	SharedNamespaces []string `json:"SharedNamespaces"`

	// State represents the current state of the pod.
	State string `json:"State,omitempty"`

	// VolumesFrom contains the containers that the pod inherits mounts from
	VolumesFrom []string `json:"volumes_from"`
}

// Validate validates this pod inspect libpod o k body
func (o *PodInspectLibpodOKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBlkioDeviceReadBps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateContainers(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCreated(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDevices(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateInfraConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMounts(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PodInspectLibpodOKBody) validateBlkioDeviceReadBps(formats strfmt.Registry) error {
	if swag.IsZero(o.BlkioDeviceReadBps) { // not required
		return nil
	}

	for i := 0; i < len(o.BlkioDeviceReadBps); i++ {
		if swag.IsZero(o.BlkioDeviceReadBps[i]) { // not required
			continue
		}

		if o.BlkioDeviceReadBps[i] != nil {
			if err := o.BlkioDeviceReadBps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("podInspectLibpodOK" + "." + "device_read_bps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("podInspectLibpodOK" + "." + "device_read_bps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *PodInspectLibpodOKBody) validateContainers(formats strfmt.Registry) error {
	if swag.IsZero(o.Containers) { // not required
		return nil
	}

	for i := 0; i < len(o.Containers); i++ {
		if swag.IsZero(o.Containers[i]) { // not required
			continue
		}

		if o.Containers[i] != nil {
			if err := o.Containers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("podInspectLibpodOK" + "." + "Containers" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("podInspectLibpodOK" + "." + "Containers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *PodInspectLibpodOKBody) validateCreated(formats strfmt.Registry) error {
	if swag.IsZero(o.Created) { // not required
		return nil
	}

	if err := validate.FormatOf("podInspectLibpodOK"+"."+"Created", "body", "date-time", o.Created.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *PodInspectLibpodOKBody) validateDevices(formats strfmt.Registry) error {
	if swag.IsZero(o.Devices) { // not required
		return nil
	}

	for i := 0; i < len(o.Devices); i++ {
		if swag.IsZero(o.Devices[i]) { // not required
			continue
		}

		if o.Devices[i] != nil {
			if err := o.Devices[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("podInspectLibpodOK" + "." + "devices" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("podInspectLibpodOK" + "." + "devices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *PodInspectLibpodOKBody) validateInfraConfig(formats strfmt.Registry) error {
	if swag.IsZero(o.InfraConfig) { // not required
		return nil
	}

	if o.InfraConfig != nil {
		if err := o.InfraConfig.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("podInspectLibpodOK" + "." + "InfraConfig")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("podInspectLibpodOK" + "." + "InfraConfig")
			}
			return err
		}
	}

	return nil
}

func (o *PodInspectLibpodOKBody) validateMounts(formats strfmt.Registry) error {
	if swag.IsZero(o.Mounts) { // not required
		return nil
	}

	for i := 0; i < len(o.Mounts); i++ {
		if swag.IsZero(o.Mounts[i]) { // not required
			continue
		}

		if o.Mounts[i] != nil {
			if err := o.Mounts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("podInspectLibpodOK" + "." + "mounts" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("podInspectLibpodOK" + "." + "mounts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this pod inspect libpod o k body based on the context it is used
func (o *PodInspectLibpodOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateBlkioDeviceReadBps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateContainers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDevices(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInfraConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PodInspectLibpodOKBody) contextValidateBlkioDeviceReadBps(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.BlkioDeviceReadBps); i++ {

		if o.BlkioDeviceReadBps[i] != nil {
			if err := o.BlkioDeviceReadBps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("podInspectLibpodOK" + "." + "device_read_bps" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("podInspectLibpodOK" + "." + "device_read_bps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *PodInspectLibpodOKBody) contextValidateContainers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Containers); i++ {

		if o.Containers[i] != nil {
			if err := o.Containers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("podInspectLibpodOK" + "." + "Containers" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("podInspectLibpodOK" + "." + "Containers" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *PodInspectLibpodOKBody) contextValidateDevices(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Devices); i++ {

		if o.Devices[i] != nil {
			if err := o.Devices[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("podInspectLibpodOK" + "." + "devices" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("podInspectLibpodOK" + "." + "devices" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *PodInspectLibpodOKBody) contextValidateInfraConfig(ctx context.Context, formats strfmt.Registry) error {

	if o.InfraConfig != nil {
		if err := o.InfraConfig.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("podInspectLibpodOK" + "." + "InfraConfig")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("podInspectLibpodOK" + "." + "InfraConfig")
			}
			return err
		}
	}

	return nil
}

func (o *PodInspectLibpodOKBody) contextValidateMounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Mounts); i++ {

		if o.Mounts[i] != nil {
			if err := o.Mounts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("podInspectLibpodOK" + "." + "mounts" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("podInspectLibpodOK" + "." + "mounts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *PodInspectLibpodOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodInspectLibpodOKBody) UnmarshalBinary(b []byte) error {
	var res PodInspectLibpodOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
