// Code generated by go-swagger; DO NOT EDIT.

package pods

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// PodTopLibpodReader is a Reader for the PodTopLibpod structure.
type PodTopLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PodTopLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPodTopLibpodOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewPodTopLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPodTopLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewPodTopLibpodOK creates a PodTopLibpodOK with default headers values
func NewPodTopLibpodOK() *PodTopLibpodOK {
	return &PodTopLibpodOK{}
}

/*
PodTopLibpodOK describes a response with status code 200, with default header values.

List processes in pod
*/
type PodTopLibpodOK struct {
	Payload *PodTopLibpodOKBody
}

// IsSuccess returns true when this pod top libpod o k response has a 2xx status code
func (o *PodTopLibpodOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this pod top libpod o k response has a 3xx status code
func (o *PodTopLibpodOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod top libpod o k response has a 4xx status code
func (o *PodTopLibpodOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod top libpod o k response has a 5xx status code
func (o *PodTopLibpodOK) IsServerError() bool {
	return false
}

// IsCode returns true when this pod top libpod o k response a status code equal to that given
func (o *PodTopLibpodOK) IsCode(code int) bool {
	return code == 200
}

func (o *PodTopLibpodOK) Error() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/top][%d] podTopLibpodOK  %+v", 200, o.Payload)
}

func (o *PodTopLibpodOK) String() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/top][%d] podTopLibpodOK  %+v", 200, o.Payload)
}

func (o *PodTopLibpodOK) GetPayload() *PodTopLibpodOKBody {
	return o.Payload
}

func (o *PodTopLibpodOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodTopLibpodOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodTopLibpodNotFound creates a PodTopLibpodNotFound with default headers values
func NewPodTopLibpodNotFound() *PodTopLibpodNotFound {
	return &PodTopLibpodNotFound{}
}

/*
PodTopLibpodNotFound describes a response with status code 404, with default header values.

No such pod
*/
type PodTopLibpodNotFound struct {
	Payload *PodTopLibpodNotFoundBody
}

// IsSuccess returns true when this pod top libpod not found response has a 2xx status code
func (o *PodTopLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod top libpod not found response has a 3xx status code
func (o *PodTopLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod top libpod not found response has a 4xx status code
func (o *PodTopLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this pod top libpod not found response has a 5xx status code
func (o *PodTopLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this pod top libpod not found response a status code equal to that given
func (o *PodTopLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *PodTopLibpodNotFound) Error() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/top][%d] podTopLibpodNotFound  %+v", 404, o.Payload)
}

func (o *PodTopLibpodNotFound) String() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/top][%d] podTopLibpodNotFound  %+v", 404, o.Payload)
}

func (o *PodTopLibpodNotFound) GetPayload() *PodTopLibpodNotFoundBody {
	return o.Payload
}

func (o *PodTopLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodTopLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPodTopLibpodInternalServerError creates a PodTopLibpodInternalServerError with default headers values
func NewPodTopLibpodInternalServerError() *PodTopLibpodInternalServerError {
	return &PodTopLibpodInternalServerError{}
}

/*
PodTopLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type PodTopLibpodInternalServerError struct {
	Payload *PodTopLibpodInternalServerErrorBody
}

// IsSuccess returns true when this pod top libpod internal server error response has a 2xx status code
func (o *PodTopLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this pod top libpod internal server error response has a 3xx status code
func (o *PodTopLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this pod top libpod internal server error response has a 4xx status code
func (o *PodTopLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this pod top libpod internal server error response has a 5xx status code
func (o *PodTopLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this pod top libpod internal server error response a status code equal to that given
func (o *PodTopLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *PodTopLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/top][%d] podTopLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PodTopLibpodInternalServerError) String() string {
	return fmt.Sprintf("[GET /libpod/pods/{name}/top][%d] podTopLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *PodTopLibpodInternalServerError) GetPayload() *PodTopLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *PodTopLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(PodTopLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
PodTopLibpodInternalServerErrorBody pod top libpod internal server error body
swagger:model PodTopLibpodInternalServerErrorBody
*/
type PodTopLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod top libpod internal server error body
func (o *PodTopLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod top libpod internal server error body based on context it is used
func (o *PodTopLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodTopLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodTopLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res PodTopLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PodTopLibpodNotFoundBody pod top libpod not found body
swagger:model PodTopLibpodNotFoundBody
*/
type PodTopLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this pod top libpod not found body
func (o *PodTopLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this pod top libpod not found body based on context it is used
func (o *PodTopLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodTopLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodTopLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res PodTopLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PodTopLibpodOKBody pod top libpod o k body
swagger:model PodTopLibpodOKBody
*/
type PodTopLibpodOKBody struct {

	// Each process running in the container, where each is process
	// is an array of values corresponding to the titles.
	// Required: true
	Processes [][]string `json:"Processes"`

	// The ps column titles
	// Required: true
	Titles []string `json:"Titles"`
}

// Validate validates this pod top libpod o k body
func (o *PodTopLibpodOKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateProcesses(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTitles(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PodTopLibpodOKBody) validateProcesses(formats strfmt.Registry) error {

	if err := validate.Required("podTopLibpodOK"+"."+"Processes", "body", o.Processes); err != nil {
		return err
	}

	return nil
}

func (o *PodTopLibpodOKBody) validateTitles(formats strfmt.Registry) error {

	if err := validate.Required("podTopLibpodOK"+"."+"Titles", "body", o.Titles); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this pod top libpod o k body based on context it is used
func (o *PodTopLibpodOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *PodTopLibpodOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PodTopLibpodOKBody) UnmarshalBinary(b []byte) error {
	var res PodTopLibpodOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
