// Code generated by go-swagger; DO NOT EDIT.

package secrets

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// SecretDeleteLibpodReader is a Reader for the SecretDeleteLibpod structure.
type SecretDeleteLibpodReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecretDeleteLibpodReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewSecretDeleteLibpodNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 404:
		result := NewSecretDeleteLibpodNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewSecretDeleteLibpodInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewSecretDeleteLibpodNoContent creates a SecretDeleteLibpodNoContent with default headers values
func NewSecretDeleteLibpodNoContent() *SecretDeleteLibpodNoContent {
	return &SecretDeleteLibpodNoContent{}
}

/*
SecretDeleteLibpodNoContent describes a response with status code 204, with default header values.

no error
*/
type SecretDeleteLibpodNoContent struct {
}

// IsSuccess returns true when this secret delete libpod no content response has a 2xx status code
func (o *SecretDeleteLibpodNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this secret delete libpod no content response has a 3xx status code
func (o *SecretDeleteLibpodNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this secret delete libpod no content response has a 4xx status code
func (o *SecretDeleteLibpodNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this secret delete libpod no content response has a 5xx status code
func (o *SecretDeleteLibpodNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this secret delete libpod no content response a status code equal to that given
func (o *SecretDeleteLibpodNoContent) IsCode(code int) bool {
	return code == 204
}

func (o *SecretDeleteLibpodNoContent) Error() string {
	return fmt.Sprintf("[DELETE /libpod/secrets/{name}][%d] secretDeleteLibpodNoContent ", 204)
}

func (o *SecretDeleteLibpodNoContent) String() string {
	return fmt.Sprintf("[DELETE /libpod/secrets/{name}][%d] secretDeleteLibpodNoContent ", 204)
}

func (o *SecretDeleteLibpodNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSecretDeleteLibpodNotFound creates a SecretDeleteLibpodNotFound with default headers values
func NewSecretDeleteLibpodNotFound() *SecretDeleteLibpodNotFound {
	return &SecretDeleteLibpodNotFound{}
}

/*
SecretDeleteLibpodNotFound describes a response with status code 404, with default header values.

No such secret
*/
type SecretDeleteLibpodNotFound struct {
	Payload *SecretDeleteLibpodNotFoundBody
}

// IsSuccess returns true when this secret delete libpod not found response has a 2xx status code
func (o *SecretDeleteLibpodNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this secret delete libpod not found response has a 3xx status code
func (o *SecretDeleteLibpodNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this secret delete libpod not found response has a 4xx status code
func (o *SecretDeleteLibpodNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this secret delete libpod not found response has a 5xx status code
func (o *SecretDeleteLibpodNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this secret delete libpod not found response a status code equal to that given
func (o *SecretDeleteLibpodNotFound) IsCode(code int) bool {
	return code == 404
}

func (o *SecretDeleteLibpodNotFound) Error() string {
	return fmt.Sprintf("[DELETE /libpod/secrets/{name}][%d] secretDeleteLibpodNotFound  %+v", 404, o.Payload)
}

func (o *SecretDeleteLibpodNotFound) String() string {
	return fmt.Sprintf("[DELETE /libpod/secrets/{name}][%d] secretDeleteLibpodNotFound  %+v", 404, o.Payload)
}

func (o *SecretDeleteLibpodNotFound) GetPayload() *SecretDeleteLibpodNotFoundBody {
	return o.Payload
}

func (o *SecretDeleteLibpodNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SecretDeleteLibpodNotFoundBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecretDeleteLibpodInternalServerError creates a SecretDeleteLibpodInternalServerError with default headers values
func NewSecretDeleteLibpodInternalServerError() *SecretDeleteLibpodInternalServerError {
	return &SecretDeleteLibpodInternalServerError{}
}

/*
SecretDeleteLibpodInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type SecretDeleteLibpodInternalServerError struct {
	Payload *SecretDeleteLibpodInternalServerErrorBody
}

// IsSuccess returns true when this secret delete libpod internal server error response has a 2xx status code
func (o *SecretDeleteLibpodInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this secret delete libpod internal server error response has a 3xx status code
func (o *SecretDeleteLibpodInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this secret delete libpod internal server error response has a 4xx status code
func (o *SecretDeleteLibpodInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this secret delete libpod internal server error response has a 5xx status code
func (o *SecretDeleteLibpodInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this secret delete libpod internal server error response a status code equal to that given
func (o *SecretDeleteLibpodInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *SecretDeleteLibpodInternalServerError) Error() string {
	return fmt.Sprintf("[DELETE /libpod/secrets/{name}][%d] secretDeleteLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *SecretDeleteLibpodInternalServerError) String() string {
	return fmt.Sprintf("[DELETE /libpod/secrets/{name}][%d] secretDeleteLibpodInternalServerError  %+v", 500, o.Payload)
}

func (o *SecretDeleteLibpodInternalServerError) GetPayload() *SecretDeleteLibpodInternalServerErrorBody {
	return o.Payload
}

func (o *SecretDeleteLibpodInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SecretDeleteLibpodInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SecretDeleteLibpodInternalServerErrorBody secret delete libpod internal server error body
swagger:model SecretDeleteLibpodInternalServerErrorBody
*/
type SecretDeleteLibpodInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this secret delete libpod internal server error body
func (o *SecretDeleteLibpodInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this secret delete libpod internal server error body based on context it is used
func (o *SecretDeleteLibpodInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SecretDeleteLibpodInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecretDeleteLibpodInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res SecretDeleteLibpodInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SecretDeleteLibpodNotFoundBody secret delete libpod not found body
swagger:model SecretDeleteLibpodNotFoundBody
*/
type SecretDeleteLibpodNotFoundBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this secret delete libpod not found body
func (o *SecretDeleteLibpodNotFoundBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this secret delete libpod not found body based on context it is used
func (o *SecretDeleteLibpodNotFoundBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SecretDeleteLibpodNotFoundBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecretDeleteLibpodNotFoundBody) UnmarshalBinary(b []byte) error {
	var res SecretDeleteLibpodNotFoundBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
