// Code generated by go-swagger; DO NOT EDIT.

package secrets_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// SecretListReader is a Reader for the SecretList structure.
type SecretListReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SecretListReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSecretListOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewSecretListInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewSecretListOK creates a SecretListOK with default headers values
func NewSecretListOK() *SecretListOK {
	return &SecretListOK{}
}

/*
SecretListOK describes a response with status code 200, with default header values.

Secret list response
*/
type SecretListOK struct {
	Payload []*models.SecretInfoReportCompat
}

// IsSuccess returns true when this secret list o k response has a 2xx status code
func (o *SecretListOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this secret list o k response has a 3xx status code
func (o *SecretListOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this secret list o k response has a 4xx status code
func (o *SecretListOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this secret list o k response has a 5xx status code
func (o *SecretListOK) IsServerError() bool {
	return false
}

// IsCode returns true when this secret list o k response a status code equal to that given
func (o *SecretListOK) IsCode(code int) bool {
	return code == 200
}

func (o *SecretListOK) Error() string {
	return fmt.Sprintf("[GET /secrets][%d] secretListOK  %+v", 200, o.Payload)
}

func (o *SecretListOK) String() string {
	return fmt.Sprintf("[GET /secrets][%d] secretListOK  %+v", 200, o.Payload)
}

func (o *SecretListOK) GetPayload() []*models.SecretInfoReportCompat {
	return o.Payload
}

func (o *SecretListOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSecretListInternalServerError creates a SecretListInternalServerError with default headers values
func NewSecretListInternalServerError() *SecretListInternalServerError {
	return &SecretListInternalServerError{}
}

/*
SecretListInternalServerError describes a response with status code 500, with default header values.

Internal server error
*/
type SecretListInternalServerError struct {
	Payload *SecretListInternalServerErrorBody
}

// IsSuccess returns true when this secret list internal server error response has a 2xx status code
func (o *SecretListInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this secret list internal server error response has a 3xx status code
func (o *SecretListInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this secret list internal server error response has a 4xx status code
func (o *SecretListInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this secret list internal server error response has a 5xx status code
func (o *SecretListInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this secret list internal server error response a status code equal to that given
func (o *SecretListInternalServerError) IsCode(code int) bool {
	return code == 500
}

func (o *SecretListInternalServerError) Error() string {
	return fmt.Sprintf("[GET /secrets][%d] secretListInternalServerError  %+v", 500, o.Payload)
}

func (o *SecretListInternalServerError) String() string {
	return fmt.Sprintf("[GET /secrets][%d] secretListInternalServerError  %+v", 500, o.Payload)
}

func (o *SecretListInternalServerError) GetPayload() *SecretListInternalServerErrorBody {
	return o.Payload
}

func (o *SecretListInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SecretListInternalServerErrorBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SecretListInternalServerErrorBody secret list internal server error body
swagger:model SecretListInternalServerErrorBody
*/
type SecretListInternalServerErrorBody struct {

	// API root cause formatted for automated parsing
	// Example: API root cause
	Because string `json:"cause,omitempty"`

	// human error message, formatted for a human to read
	// Example: human error message
	Message string `json:"message,omitempty"`

	// http response code
	ResponseCode int64 `json:"response,omitempty"`
}

// Validate validates this secret list internal server error body
func (o *SecretListInternalServerErrorBody) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this secret list internal server error body based on context it is used
func (o *SecretListInternalServerErrorBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *SecretListInternalServerErrorBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SecretListInternalServerErrorBody) UnmarshalBinary(b []byte) error {
	var res SecretListInternalServerErrorBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
