// Code generated by go-swagger; DO NOT EDIT.

package system_compat

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/skupperproject/skupper/client/generated/libpod/models"
)

// SystemVersionReader is a Reader for the SystemVersion structure.
type SystemVersionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SystemVersionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSystemVersionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		return nil, runtime.NewAPIError("response status code does not match any response statuses defined for this endpoint in the swagger spec", response, response.Code())
	}
}

// NewSystemVersionOK creates a SystemVersionOK with default headers values
func NewSystemVersionOK() *SystemVersionOK {
	return &SystemVersionOK{}
}

/*
SystemVersionOK describes a response with status code 200, with default header values.

Version
*/
type SystemVersionOK struct {
	Payload *SystemVersionOKBody
}

// IsSuccess returns true when this system version o k response has a 2xx status code
func (o *SystemVersionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this system version o k response has a 3xx status code
func (o *SystemVersionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this system version o k response has a 4xx status code
func (o *SystemVersionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this system version o k response has a 5xx status code
func (o *SystemVersionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this system version o k response a status code equal to that given
func (o *SystemVersionOK) IsCode(code int) bool {
	return code == 200
}

func (o *SystemVersionOK) Error() string {
	return fmt.Sprintf("[GET /version][%d] systemVersionOK  %+v", 200, o.Payload)
}

func (o *SystemVersionOK) String() string {
	return fmt.Sprintf("[GET /version][%d] systemVersionOK  %+v", 200, o.Payload)
}

func (o *SystemVersionOK) GetPayload() *SystemVersionOKBody {
	return o.Payload
}

func (o *SystemVersionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(SystemVersionOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SystemVersionOKBody system version o k body
swagger:model SystemVersionOKBody
*/
type SystemVersionOKBody struct {

	// API version
	APIVersion string `json:"ApiVersion,omitempty"`

	// arch
	Arch string `json:"Arch,omitempty"`

	// build time
	BuildTime string `json:"BuildTime,omitempty"`

	// components
	Components []*models.ComponentVersion `json:"Components"`

	// experimental
	Experimental bool `json:"Experimental,omitempty"`

	// git commit
	GitCommit string `json:"GitCommit,omitempty"`

	// go version
	GoVersion string `json:"GoVersion,omitempty"`

	// kernel version
	KernelVersion string `json:"KernelVersion,omitempty"`

	// min API version
	MinAPIVersion string `json:"MinAPIVersion,omitempty"`

	// os
	Os string `json:"Os,omitempty"`

	// platform
	Platform interface{} `json:"Platform,omitempty"`

	// version
	Version string `json:"Version,omitempty"`
}

// Validate validates this system version o k body
func (o *SystemVersionOKBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComponents(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SystemVersionOKBody) validateComponents(formats strfmt.Registry) error {
	if swag.IsZero(o.Components) { // not required
		return nil
	}

	for i := 0; i < len(o.Components); i++ {
		if swag.IsZero(o.Components[i]) { // not required
			continue
		}

		if o.Components[i] != nil {
			if err := o.Components[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemVersionOK" + "." + "Components" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemVersionOK" + "." + "Components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this system version o k body based on the context it is used
func (o *SystemVersionOKBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateComponents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SystemVersionOKBody) contextValidateComponents(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Components); i++ {

		if o.Components[i] != nil {
			if err := o.Components[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("systemVersionOK" + "." + "Components" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("systemVersionOK" + "." + "Components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SystemVersionOKBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SystemVersionOKBody) UnmarshalBinary(b []byte) error {
	var res SystemVersionOKBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
