// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ContainerSecurityConfig ContainerSecurityConfig is a container's security features, including
// SELinux, Apparmor, and Seccomp.
//
// swagger:model ContainerSecurityConfig
type ContainerSecurityConfig struct {

	// ApparmorProfile is the name of the Apparmor profile the container
	// will use.
	// Optional.
	ApparmorProfile string `json:"apparmor_profile,omitempty"`

	// CapAdd are capabilities which will be added to the container.
	// Conflicts with Privileged.
	// Optional.
	CapAdd []string `json:"cap_add"`

	// CapDrop are capabilities which will be removed from the container.
	// Conflicts with Privileged.
	// Optional.
	CapDrop []string `json:"cap_drop"`

	// Groups are a list of supplemental groups the container's user will
	// be granted access to.
	// Optional.
	Groups []string `json:"groups"`

	// Mask is the path we want to mask in the container. This masks the paths
	// given in addition to the default list.
	// Optional
	Mask []string `json:"mask"`

	// NoNewPrivileges is whether the container will set the no new
	// privileges flag on create, which disables gaining additional
	// privileges (e.g. via setuid) in the container.
	NoNewPrivileges bool `json:"no_new_privileges,omitempty"`

	// Privileged is whether the container is privileged.
	// Privileged does the following:
	// Adds all devices on the system to the container.
	// Adds all capabilities to the container.
	// Disables Seccomp, SELinux, and Apparmor confinement.
	// (Though SELinux can be manually re-enabled).
	// TODO: this conflicts with things.
	// TODO: this does more.
	Privileged bool `json:"privileged,omitempty"`

	// ProcOpts are the options used for the proc mount.
	ProcOpts []string `json:"procfs_opts"`

	// ReadOnlyFilesystem indicates that everything will be mounted
	// as read-only
	ReadOnlyFilesystem bool `json:"read_only_filesystem,omitempty"`

	// SeccompPolicy determines which seccomp profile gets applied
	// the container. valid values: empty,default,image
	SeccompPolicy string `json:"seccomp_policy,omitempty"`

	// SeccompProfilePath is the path to a JSON file containing the
	// container's Seccomp profile.
	// If not specified, no Seccomp profile will be used.
	// Optional.
	SeccompProfilePath string `json:"seccomp_profile_path,omitempty"`

	// SelinuxProcessLabel is the process label the container will use.
	// If SELinux is enabled and this is not specified, a label will be
	// automatically generated if not specified.
	// Optional.
	SelinuxOpts []string `json:"selinux_opts"`

	// Umask is the umask the init process of the container will be run with.
	Umask string `json:"umask,omitempty"`

	// Unmask is the path we want to unmask in the container. To override
	// all the default paths that are masked, set unmask=ALL.
	Unmask []string `json:"unmask"`

	// User is the user the container will be run as.
	// Can be given as a UID or a username; if a username, it will be
	// resolved within the container, using the container's /etc/passwd.
	// If unset, the container will be run as root.
	// Optional.
	User string `json:"user,omitempty"`

	// idmappings
	Idmappings *IDMappingOptions `json:"idmappings,omitempty"`

	// userns
	Userns *Namespace `json:"userns,omitempty"`
}

// Validate validates this container security config
func (m *ContainerSecurityConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateIdmappings(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUserns(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerSecurityConfig) validateIdmappings(formats strfmt.Registry) error {
	if swag.IsZero(m.Idmappings) { // not required
		return nil
	}

	if m.Idmappings != nil {
		if err := m.Idmappings.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("idmappings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("idmappings")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerSecurityConfig) validateUserns(formats strfmt.Registry) error {
	if swag.IsZero(m.Userns) { // not required
		return nil
	}

	if m.Userns != nil {
		if err := m.Userns.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("userns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("userns")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this container security config based on the context it is used
func (m *ContainerSecurityConfig) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateIdmappings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUserns(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ContainerSecurityConfig) contextValidateIdmappings(ctx context.Context, formats strfmt.Registry) error {

	if m.Idmappings != nil {
		if err := m.Idmappings.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("idmappings")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("idmappings")
			}
			return err
		}
	}

	return nil
}

func (m *ContainerSecurityConfig) contextValidateUserns(ctx context.Context, formats strfmt.Registry) error {

	if m.Userns != nil {
		if err := m.Userns.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("userns")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("userns")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ContainerSecurityConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ContainerSecurityConfig) UnmarshalBinary(b []byte) error {
	var res ContainerSecurityConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
